<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\FertilizerCategory;
use App\Models\FertilizerDetail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;

class FertilizerDetailController extends Controller
{
    public function index()
    {

        $fertilizerDetail = FertilizerDetail::with('category', 'fertilizerCategory')->get();
        $categories = Category::all();
        $fertilizer_categories = FertilizerCategory::all();

        // Calculate the count of fertilizer_name for each fertilizer_category
        $fertilizerCountByCategory = [];

        foreach ($fertilizer_categories as $category) {
            $fertilizerCountByCategory[$category->id] = FertilizerDetail::where('fertilizer_category_id', $category->id)
                ->count('fertilizer_name');
        }

        // Calculate the total number of fertilizer_name across all categories
        $totalFertilizers = $fertilizerDetail->count();

        return view('fertilizer-detail.index', compact('fertilizerDetail', 'categories', 'fertilizer_categories', 'fertilizerCountByCategory', 'totalFertilizers'))->with('success', session('success'));
    }

    public function create()
    {
        $categories = Category::all();
        $fertilizerCategory = FertilizerCategory::all();
        return view('fertilizer-detail.create', compact('categories', 'fertilizerCategory'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'plant_category' => 'required|exists:categories,id',
            'fertilizer_category' => 'required|exists:fertilizer_categories,id',
            'fertilizer_name' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);


        $fertilizerDetail = new FertilizerDetail();

        $fertilizerDetail->category_id = $request->plant_category;
        $fertilizerDetail->fertilizer_category_id = $request->fertilizer_category;
        $fertilizerDetail->fertilizer_name = $request->fertilizer_name;

        // Check if the request has an image file
        if ($request->hasFile('image') && isset($request->image)) {
            // Get the original file name
            $originalFileName = $request->file('image')->getClientOriginalName();

            // Store the image in the 'public/banner' directory with the original name
            $imagePath = $request->file('image')->storeAs('public/banner', $originalFileName);

            // Save the path to the database
            $fertilizerDetail->image = $imagePath; // Save the path to the database
        }


        $fertilizerDetail->save();


        return redirect()->route('fertilizer-detail.index')->with('success', 'Maklumat Baja Berjaya Disimpan.');
    }



    public function show($id)
    {
        $fertilizerDetail = FertilizerDetail::find($id);
        return view('fertilizer-detail.show', compact('fertilizerDetail'));
    }

    public function edit($id)
    {
        $fertilizerDetail = FertilizerDetail::findOrFail($id);
        $categories = Category::all();
        $fertilizer_categories = FertilizerCategory::all();

        return view('fertilizer-detail.edit', compact('fertilizerDetail', 'categories', 'fertilizer_categories'));
    }

    public function update(Request $request, $id)
    {

        $request->validate([
            'plant_category' => 'required|exists:categories,id',
            'fertilizer_category' => 'required|exists:fertilizer_categories,id',
            'fertilizer_name' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        // Find the farm by ID
        $fertilizerDetail = FertilizerDetail::findOrFail($id);

        // Update the farm's attributes
        $fertilizerDetail->category_id = $request->plant_category;
        $fertilizerDetail->fertilizer_category_id = $request->fertilizer_category;
        $fertilizerDetail->fertilizer_name = $request->fertilizer_name;

        // Handle PDF upload if a new file is provided
        if ($request->hasFile('image')) {
            // Delete the old PDF file if it exists
            if ($fertilizerDetail->image) {
                Storage::delete($fertilizerDetail->image);
            }


            $originalFileName = $request->file('image')->getClientOriginalName();
            $imagePath = $request->file('image')->storeAs('public/banner', $originalFileName);
            $fertilizerDetail->image = $imagePath; // Save the new path to the database
        }


        $fertilizerDetail->save();


        return redirect()->route('fertilizer-detail.index')->with('success', 'Kebun Berjaya Dikemaskini.');
    }


    public function destroy($id)
    {
        $fertilizerDetail = FertilizerDetail::findOrFail($id);
        $fertilizerDetail->delete();

        return redirect()->route('fertilizer-detail.index')->with('success', 'Maklumat Pokok Berjaya Dipadam.');
    }
}
