<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PestControl extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'plant_detail_id',
        'pest_control_detail_id',
        'amount',
        'amount_type',
        'description',
    ];
    protected $dates = ['deleted_at'];

    public function plantDetail()
    {
        return $this->belongsTo(PlantDetail::class);
    }
    

    public function pestControlDetail()
    {
        return $this->belongsTo(PestControlDetail::class, 'pest_control_detail_id');
    }
    public function damage()
    {
        return $this->hasMany(Damage::class); // Relationship for Damage
    }
}
