<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->enum('role', ['admin','Pekerja', 'Tuan_Kebun'])->default('Pekerja');
            $table->string('address')->nullable();
            $table->string('phone')->nullable();
            $table->enum('job_type', ['Pengopek', 'Pengait', 'Penanam', 'Tiada'])->default('Tiada');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
};
