<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prices', function (Blueprint $table) {
            $table->id();
            $table->decimal('grade_a_price', 8, 2)->nullable(); // Price for Grade A
            $table->decimal('grade_b_price', 8, 2)->nullable(); // Price for Grade B
            $table->decimal('grade_c_price', 8, 2)->nullable(); // Price for Grade C
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prices');
    }
};
