@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Tanaman</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('plantation.index') }}">Tanaman</a></li>
                        <li class="breadcrumb-item active">Tambah Tanaman</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Tanaman</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->



    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    {{-- <div class="col-lg-8">
                        <h4 class="mt-2">MAKLUMAT TANAMAN SEMASA</h4>
                        <p class="text-muted mb-4" >Sila Isi Maklumat Dibawah.</p>
                    </div> --}}
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <!-- header farm detail -->
                    <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                        style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                        <div class="row">
                            <div class="media">
                                <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        Maklumat Kebun
                                    </h5>
                                </div>
                            </div>
                        </div> <!-- end row -->
                    </div>
                    <!-- end header farm detail -->

                    <form role="form" method="POST" action="{{ route('plantation.store') }}"
                        enctype="multipart/form-data">
                        @csrf
                        <br>
                        <p class="text-muted mb-4">Sila Isi Maklumat Dibawah.</p>
                        <div class="row">
                            <div class="col-12">
                                {{-- Maklumat Kebun --}}
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label for="inputKebun" class="col-form-label">Nama Kebun</label>
                                        <select id="inputKebun" name="farm_id" class="form-control"
                                            onchange="updateFarmDetails()">
                                            <option selected>Sila Pilih</option>
                                            @foreach ($allFarms as $farm)
                                                <option value="{{ $farm->id }}"
                                                    data-category="{{ $farm->category->name }}"
                                                    data-category-id="{{ $farm->category_id }}"
                                                    data-size="{{ $farm->size }}">
                                                    {{ $farm->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriKebun" class="col-form-label">Kategori Kebun</label>
                                        <input type="text" class="form-control" id="inputKategoriKebun"
                                            name="plant_category" readonly>
                                        <input type="hidden" id="hiddenCategoryId" name="category_id">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputSaizKebun" class="col-form-label">Saiz Kebun</label>
                                        <input type="number" class="form-control" id="inputSaizKebun" name="saiz_kebun"
                                            readonly>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->

                        <!-- header plant detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Maklumat Pokok
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header plant detail -->

                        {{-- Maklumat Pokok --}}
                        <div class="row">
                            <div class="col-12">
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputNamaPokok" class="col-form-label">Nama Pokok</label>
                                        <select id="inputNamaPokok" name="plant_type" class="form-control" required
                                            onchange="updateMaturityPeriod(); updateFertilizerTypes();">
                                            <option selected>Sila Pilih</option>
                                        </select>
                                        <input type="hidden" id="hiddenCategoryId" name="plant_detail_id">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTempohKematangan" class="col-form-label">Tempoh
                                            Kematangan (Bulan)</label>
                                        <input type="number" name="plant_maturity" id="inputTempohKematangan"
                                            class="form-control" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputTarikhPenanaman" class="col-form-label">Tarikh Penanaman</label>
                                        <input type="date" name="plant_date" class="form-control"
                                            id="inputTarikhPenanaman" onchange="filterUsers()">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTarikhMenuai" class="col-form-label">Tarikh Menuai</label>
                                        <input type="date" name="harvest_date" class="form-control"
                                            id="inputTarikhMenuai" onchange="filterUsers()" readonly>
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->
                        {{-- End Maklumat Pokok --}}

                        <!-- header pekerja detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Serah Tugas
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header pekerja detail -->

                        {{-- Maklumat Pekerja --}}
                        <div class="row">
                            <div class="col-12">
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label for="inputBilanganPokok" class="col-form-label">Bilangan Tanam
                                            (Batang)</label>
                                        <input type="number" name="quantity_plant" class="form-control"
                                            id="inputBilanganPokok" placeholder="Eg: 200 Batang " required>
                                    </div>


                                    <div class="form-group col-md-6">
                                        <label for="penanam_id" class="col-form-label">Penanam</label>
                                        <select id="penanam_id" name="penanam_id" class="form-control" required>
                                            <option value="">Sila Pilih</option>
                                            @foreach ($users as $user)
                                                @if ($user->job_type == 'Penanam')
                                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="pengait_id" class="col-form-label">Pengait</label>
                                        <select id="pengait_id" name="pengait_id" class="form-control" required>
                                            <option value="">Sila Pilih</option>
                                            @foreach ($users as $user)
                                                @if ($user->job_type == 'Pengait')
                                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>

                                </div>


                            </div> <!-- end col -->
                        </div> <!-- end row -->
                        {{-- End Maklumat Pekerja --}}

                        <!-- header tumbesaran detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Maklumat Baja Tumbesaran
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header tumbesaran detail -->

                        {{-- Maklumat Baja Tumbesaran --}}
                        <div class="row">
                            <div class="col-12">
                                <p class="text-muted font-14">Maklumat Baja 1 (Tumbesaran)</p>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriBajaTumbesaran" class="col-form-label">Kategori
                                            Baja</label>
                                        {{-- <input type="hidden" id="hiddenFerCategoryId" name="fertilizer_category_id"> --}}
                                        <input type="text" class="form-control" id="inputKategoriBajaTumbesaran"
                                            value="Tumbesaran" readonly>
                                        <input type="hidden" name="fertilizer_category_id_tumbesaran" value="1">
                                        <!-- ID for Tumbesaran -->
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputNamaBajaTumbesaran" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBajaTumbesaran" name="tumbesaran_id" class="form-control">
                                            <option value="">Sila Pilih</option>
                                            <!-- Options will be populated by JavaScript -->
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBajaTumbesaran" class="col-form-label">Quantiti
                                            Baja</label>
                                        <input type ="number" name="amount" class="form-control"
                                            id="inputQuantitiBajaTumbesaran"readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantitiTumbesaran" class="col-form-label">Jenis
                                            Kuantiti</label>
                                        <input type ="text" name="amount_type" class="form-control"
                                            id="inputJenisKuantitiTumbesaran" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembajaTumbesaran" class="col-form-label">Tempoh
                                            Membaja</label>
                                        <input type ="text" name="duration" class="form-control"
                                            id="inputTempohMembajaTumbesaran" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBajaTumbesaran" class="col-form-label">Kekerapan
                                            Baja(1 Bulan)</label>
                                        <input type ="number" name="frequency" class="form-control"
                                            id="inputKekerapanBajaTumbesaran" readonly>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="tumbesaranDates" class="col-form-label">Tarikh Baja</label>
                                        <input type="text" id="tumbesaranDates" name="tumbesaran_dates"
                                            class="form-control" placeholder="Sila Pilih Tarikh">
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- End Maklumat Baja Tumbesaran --}}

                        <!-- header akar detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Maklumat Baja Akar
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header akar detail -->

                        {{-- Maklumat Baja Akar --}}
                        <div class="row">
                            <div class="col-12">
                                <p class="text-muted font-14">Maklumat Baja 2 (Akar)</p>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriBajaAkar" class="col-form-label">Kategori Baja </label>
                                        <input type="text" class="form-control" id="inputKategoriBajaAkar"
                                            value="Akar Pokok" readonly>
                                        <input type="hidden" name="fertilizer_category_id_akar" value="2">
                                        <!-- ID for Akar Pokok -->
                                    </div>


                                    <div class="form-group col-md-6">
                                        <label for="inputNamaBajaAkar" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBajaAkar" class="form-control" name="akar_id">
                                            <option value="">Sila Pilih</option>
                                            <!-- Options populated dynamically -->
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBajaAkar" class="col-form-label">Quantiti
                                            Baja Akar</label>
                                        <input type="number" id="inputQuantitiBajaAkar" class="form-control" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantitiAkar" class="col-form-label">Jenis
                                            Kuantiti</label>
                                        <input type="text" id="inputJenisKuantitiAkar" class="form-control" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembajaAkar" class="col-form-label">Tempoh
                                            Membaja</label>
                                        <input type ="text" name="duration" class="form-control"
                                            id="inputTempohMembajaAkar" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBajaAkar" class="col-form-label">Kekerapan
                                            Baja(1 Bulan)</label>
                                        <input type ="number" name="frequency" class="form-control"
                                            id="inputKekerapanBajaAkar" readonly>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="akarDates" class="col-form-label">Tarikh Baja</label>
                                        <input type="text" id="akarDates" name="akar_dates" class="form-control"
                                            placeholder="Sila Pilih Tarikh">
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- End Maklumat Baja Akar --}}

                        <!-- header buah detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Maklumat Baja Buah
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header buah detail -->

                        {{-- Maklumat Baja Buah --}}
                        <div class="row">
                            <div class="col-12">
                                <p class="text-muted font-14">Maklumat Baja 3 (Buah)</p>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriBajaBuah" class="col-form-label">Kategori Baja </label>
                                        <input type="text" class="form-control" id="inputKategoriBajaBuah"
                                            value="Buah" readonly>
                                        <input type="hidden" name="fertilizer_category_id_buah" value="3">
                                        <!-- ID for Buah -->
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputNamaBajaBuah" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBajaBuah" class="form-control" name="buah_id">
                                            <option value="">Sila Pilih</option>
                                            <!-- Options populated dynamically -->
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBajaBuah" class="col-form-label">Quantiti Baja</label>
                                        <input type="number" id="inputQuantitiBajaBuah" class="form-control" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantitiBuah" class="col-form-label">Jenis
                                            Kuantiti</label>
                                        <input type="text" id="inputJenisKuantitiBuah" class="form-control" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembajaBuah" class="col-form-label">Tempoh
                                            Membaja</label>
                                        <input type ="text" name="duration" class="form-control"
                                            id="inputTempohMembajaBuah" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBajaBuah" class="col-form-label">Kekerapan
                                            Baja(1 Bulan)</label>
                                        <input type ="number" name="frequency" class="form-control"
                                            id="inputKekerapanBajaBuah" readonly>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="buahDates" class="col-form-label">Tarikh Baja</label>
                                        <input type="text" id="buahDates" name="buah_dates" class="form-control"
                                            placeholder="Sila Pilih Tarikh">
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- End Maklumat Baja Buah --}}

                        <!-- header matang detail -->
                        <div class="nav nav-pills nav-justified form-wizard-header mb-1 bg-info text-white"
                            style="padding-left:2%; padding-top:1%; padding-bottom:1%;">
                            <div class="row">
                                <div class="media">
                                    <i class="uil uil-trees text-white font-weight-bold font-12 text-uppercase"></i> &nbsp;
                                    <div class="media-body">
                                        <h5 class="mt-1 font-14">
                                            Maklumat Baja Matang
                                        </h5>
                                    </div>
                                </div>
                            </div> <!-- end row -->
                        </div>
                        <!-- end header matang detail -->

                        {{-- Maklumat Baja Matang --}}
                        <div class="row">
                            <div class="col-12">
                                <p class="text-muted font-14">Maklumat Baja 4 (Matang)</p>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputKategoriBajaMatang" class="col-form-label">Kategori Baja </label>
                                        <input type="text" class="form-control" id="inputKategoriBajaMatang"
                                            value="Matang" readonly>
                                        <input type="hidden" name="fertilizer_category_id_matang" value="4">
                                        <!-- ID for Matang -->
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputNamaBajaMatang" class="col-form-label">Nama Baja</label>
                                        <select id="inputNamaBajaMatang" class="form-control" name="matang_id">
                                            <option value="">Sila Pilih</option>
                                            <!-- Options populated dynamically -->
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputQuantitiBajaMatang" class="col-form-label">Quantiti Baja</label>
                                        <input type="number" id="inputQuantitiBajaMatang" class="form-control" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputJenisKuantitiMatang" class="col-form-label">Jenis
                                            Kuantiti</label>
                                        <input type="text" id="inputJenisKuantitiMatang" class="form-control"
                                            readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputTempohMembajaMatang" class="col-form-label">Tempoh
                                            Membaja</label>
                                        <input type ="text" name="duration" class="form-control"
                                            id="inputTempohMembajaMatang" readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="inputKekerapanBajaMatang" class="col-form-label">Kekerapan
                                            Baja(1 Bulan)</label>
                                        <input type ="number" name="frequency" class="form-control"
                                            id="inputKekerapanBajaMatang" readonly>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="matangDates" class="col-form-label">Tarikh Baja</label>
                                        <input type="text" id="matangDates" name="matang_dates" class="form-control"
                                            placeholder="Sila Pilih Tarikh">
                                    </div>

                                </div>
                            </div>
                        </div>
                        {{-- End Maklumat Baja Matang --}}
                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-light mr-3">Batal</button>
                            <button type="submit" class="btn btn-info">Simpan</button>
                        </div>
                    </form>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div>


<script>
    const plantDetails = @json($plantDetails);
    const fertilizers = @json($fertilizers);
    const fertilizerCategories = @json($fertilizerCategories);

    // Update Farm Details
    function updateFarmDetails() {
        const farmSelect = document.getElementById('inputKebun');
        const selectedOption = farmSelect.options[farmSelect.selectedIndex];

        // Get the category and size from the selected option's data attributes
        const category = selectedOption.getAttribute('data-category');
        const categoryId = selectedOption.getAttribute('data-category-id');
        const size = selectedOption.getAttribute('data-size');

        // Update the category and size input fields
        document.getElementById('inputKategoriKebun').value = category || '';
        document.getElementById('inputSaizKebun').value = size || '';
        document.getElementById('hiddenCategoryId').value = categoryId || '';

        // Call the function to update Nama Pokok
        updatePlantTypes(categoryId);
    }

    // Update Plant Types
    function updatePlantTypes(categoryId) {
        const plantSelect = document.getElementById('inputNamaPokok');

        // Clear previous options
        plantSelect.innerHTML = '<option selected>Sila Pilih</option>';

        // Check if categoryId is valid and if plant details exist for it
        if (categoryId && plantDetails[categoryId]) {
            plantDetails[categoryId].forEach(plant => {
                const option = document.createElement('option');
                option.value = plant.id; // Use plant ID as value
                option.textContent = plant.plant_type; // Display plant type as text
                option.setAttribute('data-maturity', plant.plant_maturity); // Store maturity as data attribute
                plantSelect.appendChild(option);
            });
        } else {
            console.warn('No plant details found for the selected category.');
        }

        // Call updateFertilizerTypes function after plant types are populated
        updateFertilizerTypes(plantSelect.value); // Pass the selected plant ID to update fertilizers
    }

    // Update Maturity Period
    function updateMaturityPeriod() {
        const plantSelect = document.getElementById('inputNamaPokok');
        const selectedOption = plantSelect.options[plantSelect.selectedIndex];

        // Retrieve maturity from data attribute
        const maturity = selectedOption.getAttribute('data-maturity');

        // Update maturity input field
        document.getElementById('inputTempohKematangan').value = maturity || '';
        // Trigger harvest date calculation
        calculateHarvestDate();
    }

    // Calculate Harvest Date
    function calculateHarvestDate() {
        const plantingDateInput = document.getElementById('inputTarikhPenanaman');
        const maturityInput = document.getElementById('inputTempohKematangan');
        const harvestDateInput = document.getElementById('inputTarikhMenuai');

        // Get planting date and maturity period
        const plantingDate = plantingDateInput.value; // Format: YYYY-MM-DD
        const maturityPeriod = parseInt(maturityInput.value); // Maturity in months

        if (plantingDate && !isNaN(maturityPeriod)) {
            // Convert planting date to Date object
            const plantingDateObj = new Date(plantingDate);

            // Add maturity period (months) to planting date
            plantingDateObj.setMonth(plantingDateObj.getMonth() + maturityPeriod);

            // Format new date as YYYY-MM-DD
            const harvestDate = plantingDateObj.toISOString().split('T')[0];

            // Update the harvest date field
            harvestDateInput.value = harvestDate;

            // Validate both dates
            validateDates(plantingDate, harvestDate);
        } else {
            // Clear harvest date if inputs are invalid
            harvestDateInput.value = '';
        }
    }

    // Add event listener to recalculate when planting date changes
    document.getElementById('inputTarikhPenanaman').addEventListener('change', calculateHarvestDate);

    // Update Fertilizer Types
    function updateFertilizerTypes(plantDetailId) {
        updateTumbesaranNames(); // Update Tumbesaran
        updateAkarNames(); // Update Akar
        updateBuahNames(); // Update Buah
        updateMatangNames(); // Update Matang
    }

    // Update Tumbesaran Names
    function updateTumbesaranNames() {
        const plantDetailId = document.getElementById('inputNamaPokok').value;
        const fertilizerCategoryId = 1; // Hardcoded for Tumbesaran
        const fertilizerNameSelect = document.getElementById('inputNamaBajaTumbesaran');

        fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>'; // Clear previous options

        if (plantDetailId && fertilizers[plantDetailId]) {
            const fertilizerList = fertilizers[plantDetailId].filter(
                fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == fertilizerCategoryId
            );

            // Populate the select with fertilizer names
            fertilizerList.forEach(fertilizer => {
                const option = document.createElement('option');
                option.value = fertilizer.fertilizer_detail.id; // Fertilizer ID
                option.textContent = fertilizer.fertilizer_detail.fertilizer_name; // Fertilizer name
                option.dataset.amount = fertilizer.amount; // Additional data
                option.dataset.amountType = fertilizer.amount_type;
                option.dataset.duration = fertilizer.duration;
                option.dataset.frequency = fertilizer.frequency;
                fertilizerNameSelect.appendChild(option);
            });
        }
    }

    // Update Akar Names
    function updateAkarNames() {
        const plantDetailId = document.getElementById('inputNamaPokok').value;
        const fertilizerCategoryId = 2; // Hardcoded for Akar Pokok
        const fertilizerNameSelect = document.getElementById('inputNamaBajaAkar');

        fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>'; // Clear previous options

        if (plantDetailId && fertilizers[plantDetailId]) {
            const fertilizerList = fertilizers[plantDetailId].filter(
                fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == fertilizerCategoryId
            );

            // Populate the select with fertilizer names
            fertilizerList.forEach(fertilizer => {
                const option = document.createElement('option');
                option.value = fertilizer.fertilizer_detail.id; // Fertilizer ID
                option.textContent = fertilizer.fertilizer_detail.fertilizer_name; // Fertilizer name
                option.dataset.amount = fertilizer.amount; // Additional data
                option.dataset.amountType = fertilizer.amount_type;
                option.dataset.duration = fertilizer.duration;
                option.dataset.frequency = fertilizer.frequency;
                fertilizerNameSelect.appendChild(option);
            });
        }
    }

    // Update Buah Names
    function updateBuahNames() {
        const plantDetailId = document.getElementById('inputNamaPokok').value;
        const fertilizerCategoryId = 3; // Hardcoded for Buah
        const fertilizerNameSelect = document.getElementById('inputNamaBajaBuah');

        fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>'; // Clear previous options

        if (plantDetailId && fertilizers[plantDetailId]) {
            const fertilizerList = fertilizers[plantDetailId].filter(
                fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == fertilizerCategoryId
            );

            // Populate the select with fertilizer names
            fertilizerList.forEach(fertilizer => {
                const option = document.createElement('option');
                option.value = fertilizer.fertilizer_detail.id; // Fertilizer ID
                option.textContent = fertilizer.fertilizer_detail.fertilizer_name; // Fertilizer name
                option.dataset.amount = fertilizer.amount; // Additional data
                option.dataset.amountType = fertilizer.amount_type;
                option.dataset.duration = fertilizer.duration;
                option.dataset.frequency = fertilizer.frequency;
                fertilizerNameSelect.appendChild(option);
            });
        }
    }

    // Update Matang Names
    function updateMatangNames() {
        const plantDetailId = document.getElementById('inputNamaPokok').value;
        const fertilizerCategoryId = 4; // Hardcoded for Matang
        const fertilizerNameSelect = document.getElementById('inputNamaBajaMatang');

        fertilizerNameSelect.innerHTML = '<option value="">Sila Pilih</option>'; // Clear previous options

        if (plantDetailId && fertilizers[plantDetailId]) {
            const fertilizerList = fertilizers[plantDetailId].filter(
                fertilizer => fertilizer.fertilizer_detail.fertilizer_category_id == fertilizerCategoryId
            );

            // Populate the select with fertilizer names
            fertilizerList.forEach(fertilizer => {
                const option = document.createElement('option');
                option.value = fertilizer.fertilizer_detail.id; // Fertilizer ID
                option.textContent = fertilizer.fertilizer_detail.fertilizer_name; // Fertilizer name
                option.dataset.amount = fertilizer.amount; // Additional data
                option.dataset.amountType = fertilizer.amount_type;
                option.dataset.duration = fertilizer.duration;
                option.dataset.frequency = fertilizer.frequency;
                fertilizerNameSelect.appendChild(option);
            });
        }
    }

    // Event Listeners
    document.getElementById('inputNamaPokok').addEventListener('change', function() {
        const plantDetailId = this.value;
        updateFertilizerTypes(plantDetailId); // Trigger fertilizer type update on plant selection
    });

    document.getElementById('inputNamaBajaTumbesaran').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex]; // Get the selected option

        // Populate the fields with data attributes for Tumbesaran
        document.getElementById('inputQuantitiBajaTumbesaran').value = selectedOption.dataset.amount || '';
        document.getElementById('inputJenisKuantitiTumbesaran').value = selectedOption.dataset.amountType || '';
        document.getElementById('inputTempohMembajaTumbesaran').value = selectedOption.dataset.duration || '';
        document.getElementById('inputKekerapanBajaTumbesaran').value = selectedOption.dataset.frequency || '';
    });

    document.getElementById('inputNamaBajaAkar').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex]; // Get the selected option

        // Populate the fields with data attributes for Akar
        document.getElementById('inputQuantitiBajaAkar').value = selectedOption.dataset.amount || '';
        document.getElementById('inputJenisKuantitiAkar').value = selectedOption.dataset.amountType || '';
        document.getElementById('inputTempohMembajaAkar').value = selectedOption.dataset.duration || '';
        document.getElementById('inputKekerapanBajaAkar').value = selectedOption.dataset.frequency || '';
    });

    document.getElementById('inputNamaBajaBuah').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex]; // Get the selected option

        // Populate the fields with data attributes for Buah
        document.getElementById('inputQuantitiBajaBuah').value = selectedOption.dataset.amount || '';
        document.getElementById('inputJenisKuantitiBuah').value = selectedOption.dataset.amountType || '';
        document.getElementById('inputTempohMembajaBuah').value = selectedOption.dataset.duration || '';
        document.getElementById('inputKekerapanBajaBuah').value = selectedOption.dataset.frequency || '';
    });

    document.getElementById('inputNamaBajaMatang').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex]; // Get the selected option

        // Populate the fields with data attributes for Matang
        document.getElementById('inputQuantitiBajaMatang').value = selectedOption.dataset.amount || '';
        document.getElementById('inputJenisKuantitiMatang').value = selectedOption.dataset.amountType || '';
        document.getElementById('inputTempohMembajaMatang').value = selectedOption.dataset.duration || '';
        document.getElementById('inputKekerapanBajaMatang').value = selectedOption.dataset.frequency || '';
    });
</script>

    {{-- Validate Tarikh Assign --}}
    <script>
        function validateDates(plantDate, harvestDate) {
            // Check if the selected plant date and harvest date are already assigned
            fetch(`/check-date?plant_date=${plantDate}&harvest_date=${harvestDate}`)
                .then(response => response.json())
                .then(data => {
                    // Check if both Penanam and Pengait are assigned
                    const penanamAlert = data.assignedPenanam ?
                        `Tarikh Penanaman ini sudah ditetapkan ke ${data.assignedPenanam} dan` : '';
                    const pengaitAlert = data.assignedPengait ?
                        `Tarikh Menuai ini sudah ditetapkan kepada ${data.assignedPengait}.` : '';

                    // If both alerts exist, show them together
                    if (penanamAlert && pengaitAlert) {
                        alert(
                            `${penanamAlert} ${pengaitAlert}Tarikh ini telah ditetapkan penanaman dan penuaian. Sila pilih tarikh lain`
                        );
                        document.getElementById('inputTarikhPenanaman').value = ''; // Clear planting date input

                        document.getElementById('inputTarikhMenuai').value = ''; // Clear harvest date input
                    } else if (penanamAlert) {
                        alert(penanamAlert + ' Sila pilih tarikh lain atau tetapkan kepada Penanam lain.');
                    } else if (pengaitAlert) {
                        alert(pengaitAlert + ' Sila pilih tarikh lain atau tetapkan kepada Pengait lain.');
                    }
                });
        }
    </script>

    {{-- Insert Multiple Tarikh --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            flatpickr("#matangDates", {
                mode: "multiple", // Enables multi-date selection
                dateFormat: "Y-m-d", // Format of the dates
                defaultDate: [], // Optional: Prepopulate dates
                allowInput: true,
                locale: {
                    firstDayOfWeek: 1 // Start the week on Monday
                }
            });

            flatpickr("#buahDates", {
                mode: "multiple",
                dateFormat: "Y-m-d",
                defaultDate: [],
                allowInput: true,
                locale: {
                    firstDayOfWeek: 1
                }
            });

            flatpickr("#tumbesaranDates", {
                mode: "multiple",
                dateFormat: "Y-m-d",
                defaultDate: [],
                allowInput: true,
                locale: {
                    firstDayOfWeek: 1
                }
            });

            flatpickr("#akarDates", {
                mode: "multiple",
                dateFormat: "Y-m-d",
                defaultDate: [],
                allowInput: true,
                locale: {
                    firstDayOfWeek: 1
                }
            });
        });
    </script>
@endsection
