<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pest_controls', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plant_detail_id');
            $table->foreignId('pest_control_detail_id');
            $table->integer('amount')->nullable();
            $table->string('amount_type')->nullable();
            $table->longText('description')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pest_controls');
    }
};
