@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('sales.index') }}">Hasil Jualan</a></li>
                        <li class="breadcrumb-item active">Cetak Resit</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Jualan</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <!-- Invoice Logo-->
                    <div class="clearfix">
                        <div class="float-left mb-3">
                            <img src="{{ asset('assets/images/logo-light.png') }}" alt="" height="18">
                        </div>
                        <div class="float-right">
                            <h4 class="m-0 d-print-none">Invois</h4>
                        </div>
                    </div>

                    <!-- Invoice Detail-->
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="float-left mt-3">
                                <p><b>{{ $sales->customer->company_name }}</b></p>
                                <p class="text-muted font-13">Sila rujuk di bawah untuk butiran pembelian.
                                    Diminta untuk menghubungi saya sekiranya terdapat sebarang pertanyaan.</p>
                            </div>

                        </div><!-- end col -->
                        <div class="col-sm-4 offset-sm-2">
                            <div class="mt-3 float-sm-right">
                                <p class="font-13"><strong>Tarikh Pesan: </strong> &nbsp;&nbsp;&nbsp;
                                    {{ $sales->created_at->format('d-m-Y') }}</p>
                                <p class="font-13"><strong>Status Pesan: </strong> <span
                                        class="badge badge-success float-right">Bayar</span></p>
                                <p class="font-13"><strong>Pesan ID: </strong> <span
                                        class="float-right">#P00{{ $sales->index + 1 }}</span></p>
                            </div>
                        </div><!-- end col -->
                    </div>
                    <!-- end row -->

                    <div class="row mt-4">
                        <div class="col-sm-4">
                            <h6>Alamat Penjual</h6>
                            <address>
                                Wakallah Bin Wali<br>
                                Lot 1092 Jalan Taman Bahagia,<br>
                                45400 Sungai Ayer Tawar,<br>
                                Selangor<br>
                                <abbr title="Phone">P:</abbr> (60) 123456789
                            </address>
                        </div> <!-- end col-->

                        <div class="col-sm-4">
                            <h6>Alamat Pembeli</h6>
                            @php
                                $addressParts = explode(',', $sales->customer->address);
                            @endphp
                            <address>
                                {{ $sales->customer->customer_name }}<br>
                                @foreach ($addressParts as $index => $part)
                                    {{ trim($part) }}{{ $index < count($addressParts) - 1 ? ',' : '' }}<br>
                                @endforeach
                                <abbr title="Phone">P:</abbr>{{ $sales->customer->phone_number }}
                            </address>

                        </div> <!-- end col-->

                       
                    </div>
                    <!-- end row -->



                    <div class="row">
                        <div class="col-12">
                            <div class="table-responsive">
                                <table class="table mt-4">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Penerangan</th>
                                            <th>Kuantiti</th>
                                            <th>Harga Seunit</th>
                                            <th class="text-right">Jumlah</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>1</td>
                                            <td>
                                                <b>Gred A</b> <br>
                                            {{$sales->harvest->plantation->plantDetail->plant_type}}
                                            </td>
                                            <td>{{$sales->grade_a_sale}} Biji</td>
                                            <td>RM {{$sales->price->grade_a_price}}</td>
                                            <td class="text-right">RM {{$sales->total_sale_grade_a}}</td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>
                                                <b>Gred B</b> <br>
                                              {{$sales->harvest->plantation->plantDetail->plant_type}}  
                                            </td>
                                            <td>{{$sales->grade_c_sale}} Biji</td>
                                            <td>RM {{$sales->price->grade_b_price}}</td>
                                            <td class="text-right">RM {{$sales->total_sale_grade_b}}</td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>
                                                <b>Gred C</b> <br>
                                              {{$sales->harvest->plantation->plantDetail->plant_type}}  
                                            </td>
                                            <td>{{$sales->grade_c_sale}} Biji</td>
                                            <td>RM {{$sales->price->grade_c_price}}</td>
                                            <td class="text-right">RM {{$sales->total_sale_grade_c}}</td>
                                        </tr>


                                    </tbody>
                                </table>
                            </div> <!-- end table-responsive-->
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->

                    <div class="row">
                        <div class="col-sm-6">
                            <div class="clearfix pt-3">
                                <h6 class="text-muted">Nota:</h6>
                                <small>
                                    Sila pastikan nombor pesanan belian (PO) disertakan pada invois.
                                </small>
                            </div>
                        </div> <!-- end col -->
                        <div class="col-sm-6">
                            <div class="float-right mt-3 mt-sm-0">
                                <h3>RM{{$sales->total_sale}}</h3>
                            </div>
                            <div class="clearfix"></div>
                        </div> <!-- end col -->
                    </div>
                    <!-- end row-->

                    <div class="d-print-none mt-4">
                        <div class="text-right">
                            <a href="javascript:window.print()" class="btn btn-info"><i class="mdi mdi-printer"></i>
                                Cetak</a>

                        </div>
                    </div>
                    <!-- end buttons -->

                </div> <!-- end card-body-->
            </div> <!-- end card -->
        </div> <!-- end col-->
    </div>
@endsection
