<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Fertilizer extends Model
{
    // use HasFactory, SoftDeletes;
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'plant_detail_id',
        'fertilizer_detail_id',
        'amount',
        'amount_type',
        'duration',
        'frequency',
    ];

    public function plantDetail()
    {
        return $this->belongsTo(PlantDetail::class);
    }

    public function fertilizerDetail()
    {
        return $this->belongsTo(FertilizerDetail::class);
    }

    public function plantationsAsTumbesaran()
    {
        return $this->hasMany(Plantation::class, 'tumbesaran_id'); // Relationship for Tumbesaran
    }

    public function plantationsAsAkar()
    {
        return $this->hasMany(Plantation::class, 'akar_id'); // Relationship for Akar
    }

    public function plantationsAsBuah()
    {
        return $this->hasMany(Plantation::class, 'buah_id'); // Relationship for Buah
    }

    public function plantationsAsMatang()
    {
        return $this->hasMany(Plantation::class, 'matang_id'); // Relationship for Matang
    }
}
