@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card widget-inline">
                <div class="card-body p-0">
                    <div class="row no-gutters">
                        <!-- Jumlah Aduan -->
                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body bg-primary text-center">
                                    <i class="dripicons-to-do text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>{{ $jumlahAduan }}</span></h3>
                                    <p class="text-white font-15 mb-0">Jumlah Aduan</p>
                                </div>
                            </div>
                        </div>

                        <!-- Aduan Baru -->
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-danger text-center">
                                    <i class="dripicons-checklist text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>{{ $aduanBaru }}</span></h3>
                                    <p class="text-white font-15 mb-0">Aduan Baru</p>
                                </div>
                            </div>
                        </div>

                        <!-- Serah Tugas -->
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-warning text-center">
                                    <i class="dripicons-loading text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>{{ $serahTugas }}</span></h3>
                                    <p class="text-white font-15 mb-0">Serah Tugas</p>
                                </div>
                            </div>
                        </div>

                        <!-- Aduan Selesai -->
                        <div class="col">
                            <div class="card shadow-none m-0 border-left">
                                <div class="card-body bg-success text-center">
                                    <i class="dripicons-lightbulb text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>{{ $aduanSelesai }}</span></h3>
                                    <p class="text-white font-15 mb-0">Aduan Selesai</p>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end row -->
                </div>
            </div> <!-- end card-box-->
        </div> <!-- end col-->
    </div>
    <!-- end row-->

    @if (auth()->user()->role === 'Tuan_Kebun')
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- HTML -->
                        <div id="chartdiv"></div>

                    </div> <!-- end card body-->
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>
        <!-- end row-->
    @endif


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Laporan Aduan</h4>
                        @if (auth()->user()->role === 'Pekerja')
                            <a href="{{ route('damage.create') }}" class="btn btn-primary btn-sm"
                                style="position: absolute; right:2%;">+Tambah Aduan</a>
                            <br><br>
                        @endif
                    </div>


                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Bil.</th>
                                <th>Kebun</th>
                                <th>Jenis Aduan</th>
                                <th>Tarikh Aduan</th>
                                @if (auth()->user()->role === 'Tuan_Kebun')
                                    <th>Pengadu</th>
                                @endif
                                <th>Status</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach ($damages as $damage)
                                <tr>
                                    <td>{{ $loop->index + 1 }}</td>
                                    <td>{{ $damage->plantation->farm->name }}</td>
                                    <td>
                                        @if ($damage->damage_category == 'Penyakit')
                                            <span class="badge badge-info-lighten"><i
                                                    class="mdi mdi-lotion-plus-outline"></i>Penyakit</span>
                                        @elseif ($damage->damage_category == 'Haiwan Perosak')
                                            <span class="badge badge-warning-lighten"><i
                                                    class="mdi mdi-pig-variant"></i>Haiwan Perosak</span>
                                        @elseif ($damage->damage_category == 'Lain-lain')
                                            <span class="badge badge-primary-lighten"><i
                                                    class="mdi mdi-tools"></i>Lain-lain</span>
                                        @endif
                                    </td>
                                    <td>{{ $damage->created_at->format('d F Y') }}</td>
                                    @if (auth()->user()->role === 'Tuan_Kebun')
                                        <td>{{ $damage->worker->name }}</td>
                                    @endif
                                    <td>
                                        @if ($damage->status == 'Baru')
                                            <span class="badge badge-danger">Baru</span>
                                        @elseif ($damage->status == 'Serah Tugas')
                                            <span class="badge badge-warning">Serah Tugas</span>
                                        @elseif ($damage->status == 'Dalam Kerja')
                                            <span class="badge badge-info">Dalam Kerja</span>
                                        @elseif ($damage->status == 'Selesai')
                                            <span class="badge badge-success">Selesai</span>
                                        @endif
                                    </td>
                                    <td class="table-action">
                                        <a href="{{ route('damage.show', $damage->id) }}" class="action-icon"> <i
                                                class="mdi mdi-eye-check text-primary"></i></a>
                                        @if (auth()->user()->role === 'Tuan_Kebun' && $damage->status == 'Baru')
                                            <a href="{{ route('damage.edit', $damage->id) }}" class="action-icon"> <i
                                                    class="mdi mdi-account-multiple-plus text-info"></i></a>
                                        @endif
                                        @if (auth()->user()->role === 'Pekerja' && $damage->status == 'Serah Tugas')
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#statusDalamKerjaModal-{{ $damage->id }}"> <i
                                                    class="mdi mdi-file-document-edit text-info"></i></a>
                                        @endif
                                        @if (auth()->user()->role === 'Pekerja' && $damage->status == 'Dalam Kerja')
                                            <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                                data-target="#kemaskiniStatusAduan-modal-{{ $damage->id }}"> <i
                                                    class="mdi mdi-square-edit-outline  text-success"></i></a>
                                        @endif
                                    </td>
                                </tr>

                                <!-- Status Dalam Kerja Modal -->
                                <div class="modal fade" id="statusDalamKerjaModal-{{ $damage->id }}" tabindex="-1"
                                    role="dialog" aria-labelledby="statusModalLabel-{{ $damage->id }}"
                                    aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="statusModalLabel-{{ $damage->id }}">
                                                    Kemaskini Status {{ $damage->plantation->farm->name }}</h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">

                                                Anda Pasti Mahu Kemaskini Status Aduan {{ $damage->status }}
                                                kepada <b>Dalam Kerja</b>?
                                                <br>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary"
                                                    data-dismiss="modal">Batal</button>
                                                <form method="POST" action="{{ route('damage.aduan', $damage->id) }}">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" class="btn btn-primary">Betul</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <!-- kemaskiniStatusAduan modal -->
                                <div id="kemaskiniStatusAduan-modal-{{ $damage->id }}" class="modal fade"
                                    tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Status Aduan
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('damage.kemaskiniAduan', $damage->id) }}"
                                                    method="POST" enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="form-row">
                                                        <div class="form-group col-md-6">
                                                            <label for="inputState" class="col-form-label">Nama
                                                                Kebun</label>
                                                            <input type="text" name="plant_category"
                                                                class="form-control"
                                                                value="{{ $damage->plantation->farm->name }}">
                                                        </div>
                                                        <div class="form-group col-md-6">
                                                            <label for="inputEmail4" class="col-form-label">Nama
                                                                Pokok</label>
                                                            <input type="text" name="plant_type" class="form-control"
                                                                value="{{ $damage->plantation->plantDetail->plant_type }}">
                                                        </div>
                                                        <div class="form-group col-md-12">
                                                            <label for="inputEmail4"
                                                                class="col-form-label">Penyelesaian</label>
                                                            <input type="text" name="solution_category"
                                                                class="form-control"
                                                                value="{{ $damage->solution_category }}">
                                                        </div>
                                                        @if ($damage->solution_category == 'Meracun')
                                                            <div class="form-group col-md-6">
                                                                <label for="inputState" class="col-form-label">Nama
                                                                    Racun</label>
                                                                <input type="text" name="pest_name"
                                                                    class="form-control"
                                                                    value="{{ $damage->pestControl->pestControlDetail->pest_name ?? 'N/a' }}">
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label for="inputEmail4" class="col-form-label">Kuantiti
                                                                    Racun</label>
                                                                <input type="text" name="amount" class="form-control"
                                                                    value="{{ $damage->pestControl->amount ?? 'N/a' }} {{ $damage->pestControl->amount_type ?? 'N/a' }}">
                                                            </div>

                                                            <div class="form-group col-md-12">
                                                                <label for="pdf" class="col-form-label">Muat Naik
                                                                    Gambar</label>
                                                                <input type="file" name="image_work"
                                                                    class="form-control" accept="image/">
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-primary">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->


    <style>
        #chartdiv {
            width: 100%;
            height: 300px;
        }
    </style>

    <!-- Resources -->
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/percent.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>

    <!-- Chart code -->
    <script>
        am5.ready(function() {
            // Create root element
            var root = am5.Root.new("chartdiv");

            // Set themes
            root.setThemes([
                am5themes_Animated.new(root)
            ]);

            // Create chart
            var chart = root.container.children.push(am5percent.PieChart.new(root, {
                layout: root.verticalLayout
            }));

            // Create series
            var series = chart.series.push(am5percent.PieSeries.new(root, {
                valueField: "value",
                categoryField: "category"
            }));

            // Set data dynamically from the controller
            series.data.setAll([{
                    value: {{ $damageCategories['Haiwan Perosak'] }},
                    category: "Haiwan Perosak"
                },
                {
                    value: {{ $damageCategories['Penyakit'] }},
                    category: "Penyakit"
                },
                {
                    value: {{ $damageCategories['Lain-lain'] }},
                    category: "Lain-lain"
                }
            ]);

            // Play initial series animation
            series.appear(1000, 100);
        }); // end am5.ready()
    </script>
@endsection
