@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('harvest.index') }}">Hasil Kebun</a></li>
                        <li class="breadcrumb-item active">Papar Hasil</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Hasil</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-sm-6">
            <div class="card">
                <div class="card-body">
                    <!-- HTML -->
                    <h4 class="header-title">Bilangan Tuaian (Tandan)</h4>
                    <div id="chartdiv"></div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->

        <div class="col-sm-6">
            <div class="card">
                <div class="card-body">
                    <!-- HTML -->
                    <h4 class="header-title">Bilangan Tuaian (Kg)</h4>
                    <div id="chartdiv2"></div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->




    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if (auth()->user()->role === 'Tuan_Kebun')
                        <div class="card text-white bg-info overflow-hidden" style="padding-left:2%;">
                        @elseif (auth()->user()->role === 'Pekerja')
                            <div class="card text-white bg-primary overflow-hidden" style="padding-left:2%;">
                    @endif
                    <div class="row">
                        <div class="col-6">
                            <!-- assignee -->
                            <p class="mt-2 mb-1 text-white font-weight-bold font-12 text-uppercase">Ditugaskan Kepada</p>
                            <div class="media">
                                <i class="dripicons-user text-white"></i> &nbsp;
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        {{ $harvest->plantation->pengait->name }}
                                    </h5>
                                </div>
                            </div>
                            <!-- end assignee -->
                        </div> <!-- end col -->

                        <div class="col-6">
                            <!-- start due date -->
                            <p class="mt-2 mb-1 text-white font-weight-bold font-12 text-uppercase">Tarikh Tugasan</p>
                            <div class="media">
                                <i class="uil uil-schedule font-18 text-white mr-1"></i>
                                <div class="media-body">
                                    <h5 class="mt-1 font-14">
                                        {{ $harvest->harvest_date }}
                                    </h5>
                                </div>
                            </div>
                            <!-- end due date -->
                        </div> <!-- end col -->
                    </div> <!-- end row -->


                </div>
                <br>
                <h6 class="text-dark">MAKLUMAT KEBUN:</h6>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="inputEmail4" class="col-form-label">Nama Kebun</label>
                        <input type="email" class="form-control" id="inputEmail4"
                            value=" {{ $harvest->plantation->farm->name }}">
                    </div>
                    <div class="form-group col-md-6 ">
                        <label for="inputEmail4" class="col-form-label">Bilangan Tuaian</label>
                        <input type="email" class="form-control" id="inputEmail4"
                            value=" {{ $harvest->plantation->quantity_plant }} Tandan">
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="inputState" class="col-form-label">Kategori Kebun</label>
                        <input type="email" class="form-control" id="inputEmail4"
                            value=" {{ $harvest->plantation->farm->category->name }}">
                    </div>

                    <div class="form-group col-md-6">
                        <label for="inputState" class="col-form-label">Jenis Pokok</label>
                        <input type="email" class="form-control" id="inputEmail4"
                            value=" {{ $harvest->plantation->plantDetail->plant_type }}">
                    </div>
                </div>

                <div class="table-responsive mt-4">
                    <h6 class="text-dark">MAKLUMAT HASIL:</h6>

                    <table class="table table-bordered table-centered mb-0">
                        <thead class="thead-light">
                            <tr>
                                <th>Gred</th>
                                <th>Bilangan (Tandan)</th>
                                <th>Kuantiti (Kg)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Gred A</td>
                                <td>{{ $harvest->grade_a_quantity ?? 'Tiada Data' }}</td>
                                <td>{{ $harvest->grade_a_weight ?? 'Tiada Data' }}</td>
                            </tr>
                            <tr>
                                <td>Gred B</td>
                                <td>{{ $harvest->grade_b_quantity ?? 'Tiada Data' }}</td>
                                <td>{{ $harvest->grade_b_weight ?? 'Tiada Data' }}</td>
                            </tr>
                            <tr>
                                <td>Gred C</td>
                                <td>{{ $harvest->grade_c_quantity ?? 'Tiada Data' }}</td>
                                <td>{{ $harvest->grade_c_weight ?? 'Tiada Data' }}</td>
                            </tr>
                            <tr>
                                <td>Gred Tolak</td>
                                <td>{{ $harvest->grade_reject_quantity ?? 'Tiada Data' }}</td>
                                <td>{{ $harvest->grade_reject_weight ?? 'Tiada Data' }}</td>
                            </tr>

                            <tr class="text-dark">
                                <th style="text-align: right;"></th>
                                <th style="text-align: right;">Jumlah</th>
                                <th>{{ $harvest->total_weight ?? 'Tiada Data' }} Kg</th>
                            </tr>
                        </tbody>
                    </table>
                </div>
                @if (auth()->user()->role === 'Tuan_Kebun')
                    <div class="table-responsive mt-4">
                        <h6 class="text-dark">MAKLUMAT HASIL TAK JUAL:</h6>

                        <table class="table table-bordered table-centered mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>Gred</th>
                                    <th>Kuantiti (Kg)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Gred A</td>
                                    <td>{{ $harvest->grade_a_available ?? 'Tiada Data' }}</td>
                                </tr>
                                <tr>
                                    <td>Gred B</td>
                                    <td>{{ $harvest->grade_b_available ?? 'Tiada Data' }}</td>
                                </tr>
                                <tr>
                                    <td>Gred C</td>
                                    <td>{{ $harvest->grade_c_available ?? 'Tiada Data' }}</td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                @endif
                <br>
                <div class="text-center mt-2">
                    <button type="button" onclick="history.back()" class="btn btn-primary">Kembali</button>
                </div>
            </div>
        </div> <!-- end card body-->
    </div> <!-- end card -->
    </div><!-- end col-->
    </div><!-- end row-->



    <style>
        #chartdiv,
        #chartdiv2 {
            width: 100%;
            height: 250px;
        }
    </style>

    <!-- Resources -->
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/percent.js"></script>

   
    <script>
        am5.ready(function() {
    
            // Create root element
            var root = am5.Root.new("chartdiv");
    
            // Set themes
            root.setThemes([
                am5themes_Animated.new(root)
            ]);
    
            // Create chart
            var chart = root.container.children.push(am5xy.XYChart.new(root, {
                panX: true,
                panY: true,
                wheelX: "panX",
                wheelY: "zoomX",
                pinchZoomX: true,
                paddingLeft: 0,
                paddingRight: 1
            }));
    
            // Add cursor
            var cursor = chart.set("cursor", am5xy.XYCursor.new(root, {}));
            cursor.lineY.set("visible", false);
    
            // Create axes
            var xRenderer = am5xy.AxisRendererX.new(root, {
                minGridDistance: 30,
                minorGridEnabled: true
            });
    
            xRenderer.labels.template.setAll({
                rotation: -90,
                centerY: am5.p50,
                centerX: am5.p100,
                paddingRight: 15
            });
    
            xRenderer.grid.template.setAll({
                location: 1
            });
    
            var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {
                maxDeviation: 0.3,
                categoryField: "grade",
                renderer: xRenderer,
                tooltip: am5.Tooltip.new(root, {})
            }));
    
            xAxis.get("renderer").labels.template.set("text", "Gred");
    
            var yRenderer = am5xy.AxisRendererY.new(root, {
                strokeOpacity: 0.1
            });
    
            var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
                maxDeviation: 0.3,
                renderer: yRenderer
            }));
    
            yAxis.get("renderer").labels.template.set("text", "Tandan");
    
            // Create series
            var series = chart.series.push(am5xy.ColumnSeries.new(root, {
                name: "Series 1",
                xAxis: xAxis,
                yAxis: yAxis,
                valueYField: "quantity",
                sequencedInterpolation: true,
                categoryXField: "grade",
                tooltip: am5.Tooltip.new(root, {
                    labelText: "{valueY}"
                })
            }));
    
            series.columns.template.setAll({
                cornerRadiusTL: 5,
                cornerRadiusTR: 5,
                strokeOpacity: 0
            });
    
            series.columns.template.adapters.add("fill", function(fill, target) {
                return chart.get("colors").getIndex(series.columns.indexOf(target));
            });
    
            series.columns.template.adapters.add("stroke", function(stroke, target) {
                return chart.get("colors").getIndex(series.columns.indexOf(target));
            });
    
            // Set data
            var data = @json($chartData);
    
            xAxis.data.setAll(data);
            series.data.setAll(data);
    
            // Make stuff animate on load
            series.appear(1000);
            chart.appear(1000, 100);
    
        }); // end am5.ready()
    </script>



<script>
    am5.ready(function() {

        // Create root element
        var root = am5.Root.new("chartdiv2");

        // Set themes
        root.setThemes([
            am5themes_Animated.new(root)
        ]);

        // Create chart
        var chart = root.container.children.push(
            am5percent.PieChart.new(root, {
                endAngle: 270
            })
        );

        // Create series
        var series = chart.series.push(
            am5percent.PieSeries.new(root, {
                valueField: "value", // Field for the values (weights)
                categoryField: "category", // Field for the labels (grades)
                endAngle: 270,
                tooltip: am5.Tooltip.new(root, {
                    labelText: "{category}: {value} Kg" // Display weight in tooltip
                })
            })
        );

        // Customize labels to show weight instead of percentage
        series.labels.template.set("text", "{category}: {value} Kg");

        series.states.create("hidden", {
            endAngle: -90
        });

        // Set data
        var weightData = @json($weightChartData);
        series.data.setAll(weightData);

        legend.data.setAll(series.dataItems);

        // Animate the chart
        series.appear(1000, 100);

    }); // end am5.ready()
</script>

@endsection
