@extends('layouts.base')

@section('content')
    <!-- Display success message -->
    <br>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Rekod Harga</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card widget-inline">
                <div class="card-body p-0">
                    <div class="row no-gutters">
                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body bg-success text-center">
                                    <i class="mdi mdi-alpha-a-box-outline text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>RM {{ $latestGradeA }}</span></h3>
                                    <p class="text-white font-15 mb-0">Gred A</p>
                                </div>
                            </div>
                        </div>

                        <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body bg-warning text-center border-left border-right">
                                    <i class="mdi mdi-alpha-b-box-outline text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>RM {{ $latestGradeB }}</span></h3>
                                    <p class="text-white font-15 mb-0">Gred B</p>
                                </div>
                            </div>
                        </div>

                         <div class="col">
                            <div class="card shadow-none m-0">
                                <div class="card-body bg-danger text-center border-left">
                                    <i class="mdi mdi-alpha-c-box-outline text-white" style="font-size: 24px;"></i>
                                    <h3 class="text-white"><span>RM {{ $latestGradeC }}</span></h3>
                                    <p class="text-white font-15 mb-0">Gred C</p>
                                </div>
                            </div>
                        </div>
                    </div> <!-- end row -->
                </div>
            </div> <!-- end card-box-->
        </div> <!-- end col-->
    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Graf Harga Terkini</h4>
                    <!-- HTML -->
                    <div id="chartdiv"></div>

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <h4 class="header-title">Harga</h4>
                        <a href="javascript: void(0);" data-toggle="modal" data-target="#add-modal"
                            class="btn btn-info btn-sm" style="position: absolute; right:2%;">+Tambah Harga Terkini</a>
                        <br><br>
                    </div>

                    <table id="basic-datatable" class="table dt-responsive nowrap w-100">
                        <thead>
                            <tr>
                                <th>Tarikh Terkini</th>
                                <th>Gred A</th>
                                <th>Gred B</th>
                                <th>Gred C</th>
                                <th>Tindakan</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach ($prices as $price)
                                <tr>
                                    <td>{{ $price->created_at->format('d-m-Y') }}</td>
                                    <td>RM {{ $price->grade_a_price }}</td>
                                    <td>RM {{ $price->grade_b_price }}</td>
                                    <td>RM {{ $price->grade_c_price }}</td>
                                    <td class="table-action">
                                        <a href="javascript: void(0);" class="action-icon" data-toggle="modal"
                                            data-target="#edit-modal-{{ $price->id }}"> <i
                                                class="mdi mdi-file-document-edit text-info"></i></a>
                                    </td>
                                </tr>

                                <!-- Add modal -->
                                <div id="add-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="addModalLabel">Maklumat Harga</h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form role="form" action="{{ route('price.store') }}" method="POST"
                                                    enctype="multipart/form-data">
                                                    @csrf
                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Gred A</label>
                                                            <input type="number" name="grade_a_price" class="form-control"
                                                                placeholder="eg. RM 1.50" step="0.01" min="0">
                                                        </div>

                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Gred B</label>
                                                            <input type="number" name="grade_b_price" class="form-control"
                                                                placeholder="eg. RM 1.50" step="0.01" min="0">
                                                        </div>

                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Gred C</label>
                                                            <input type="number" name="grade_c_price" class="form-control"
                                                                placeholder="eg. RM 1.50" step="0.01" min="0">
                                                        </div>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-info">Simpan</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->


                                <!-- Edit modal -->
                                <div id="edit-modal-{{ $price->id }}" class="modal fade" tabindex="-1" role="dialog"
                                    aria-hidden="true">
                                    <div class="modal-dialog ">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="editModalLabel">Kemaskini Maklumat Harga
                                                </h4>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-hidden="true">×</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('price.update', $price->id) }}" method="POST"
                                                    enctype="multipart/form-data">
                                                    @csrf
                                                    @method('PUT')
                                                    <div class="form-row">
                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Gred A</label>
                                                            <input type="number" name="grade_a_price"
                                                                class="form-control" value="{{ $price->grade_a_price }}"
                                                                step="0.01" min="0">
                                                        </div>

                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Gred B</label>
                                                            <input type="number" name="grade_b_price"
                                                                class="form-control" value="{{ $price->grade_b_price }}"
                                                                step="0.01" min="0">
                                                        </div>

                                                        <div class="form-group col-md-12">
                                                            <label for="inputState" class="col-form-label">Gred C</label>
                                                            <input type="number" name="grade_c_price"
                                                                class="form-control" value="{{ $price->grade_c_price }}"
                                                                step="0.01" min="0">
                                                        </div>

                                                    </div>

                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light"
                                                            data-dismiss="modal">Batal</button>
                                                        <button type="submit" class="btn btn-info">Kemaskini</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div><!-- /.modal -->
                            @endforeach

                        </tbody>
                    </table>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->

    <!-- Styles -->
    <style>
        #chartdiv {
            width: 100%;
            height: 300px;
        }
    </style>

    <!-- Resources -->
    <script src="https://cdn.amcharts.com/lib/5/index.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
    <script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>

    <!-- Chart code -->
    <script>
        am5.ready(function() {
            // Create root element
            var root = am5.Root.new("chartdiv");

            // Set themes
            root.setThemes([
                am5themes_Animated.new(root)
            ]);

            // Create chart
            var chart = root.container.children.push(am5xy.XYChart.new(root, {
                panX: false,
                panY: false,
                paddingLeft: 0,
                wheelX: "panX",
                wheelY: "zoomX",
                layout: root.verticalLayout
            }));

            // Add legend
            var legend = chart.children.push(
                am5.Legend.new(root, {
                    centerX: am5.p50,
                    x: am5.p50
                })
            );

            // Fetch data from PHP (embedded directly)
            var data = [
                @foreach ($prices as $price)
                    {
                        "date": "{{ $price->created_at->format('Y-m-d') }}", // Format date
                        "grade_a_price": {{ $price->grade_a_price }},
                        "grade_b_price": {{ $price->grade_b_price }},
                        "grade_c_price": {{ $price->grade_c_price }}
                    },
                @endforeach
            ];

            // Create axes
            var xRenderer = am5xy.AxisRendererX.new(root, {
                cellStartLocation: 0.1,
                cellEndLocation: 0.9,
                minorGridEnabled: true
            });

            var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {
                categoryField: "date",
                renderer: xRenderer,
                tooltip: am5.Tooltip.new(root, {})
            }));

            xRenderer.grid.template.setAll({
                location: 1
            });

            xAxis.data.setAll(data);

            // Customize X-axis (Date)
            xAxis.get("renderer").labels.template.setAll({
                fontSize: 12, // Normal font size
                fill: am5.color("#000000") // Black color for date labels
            });

            // Create Y-axis (Price in RM)
            var yAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
                renderer: am5xy.AxisRendererY.new(root, {
                    strokeOpacity: 0.1
                }),
                numberFormat: "'RM'#.00" // Format Y-axis labels as RM
            }));

            // Customize Y-axis
            yAxis.get("renderer").labels.template.setAll({
                fontSize: 12, // Normal font size
                fill: am5.color("#000000") // Black color for price labels
            });

            // Add series for each grade
            function makeSeries(name, fieldName) {
                var series = chart.series.push(am5xy.ColumnSeries.new(root, {
                    name: name,
                    xAxis: xAxis,
                    yAxis: yAxis,
                    valueYField: fieldName,
                    categoryXField: "date"
                }));

                series.columns.template.setAll({
                    tooltipText: "{name}: RM {valueY}", // Tooltip without date
                    width: am5.percent(90),
                    tooltipY: 0,
                    strokeOpacity: 0
                });

                series.data.setAll(data);

                // Make stuff animate on load
                series.appear();

                series.bullets.push(function() {
                    return am5.Bullet.new(root, {
                        locationY: 0,
                        sprite: am5.Label.new(root, {
                            text: "RM {valueY}", // Display RM in bullet labels
                            fill: root.interfaceColors.get("alternativeText"),
                            centerY: 0,
                            centerX: am5.p50,
                            populateText: true
                        })
                    });
                });

                legend.data.push(series);
            }

            // Create series for each grade
            makeSeries("Gred A", "grade_a_price");
            makeSeries("Grade B", "grade_b_price");
            makeSeries("Grade C", "grade_c_price");

            // Make stuff animate on load
            chart.appear(1000, 100);
        }); // end am5.ready()
    </script>
@endsection
