<?php

namespace App\Http\Controllers;

use App\Models\Booking;
use App\Models\Schedule;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class ScheduleController extends Controller
{
    public function index()
    {
        return view('Admin.schedule.index');
    }

    // Fetch bookings with approved dates and specific statuses
    public function getBookings()
    {
        // Fetch bookings with status "Kerja Dalam Proses" and non-null approved_date and approved_time
        $bookings = Booking::with(['user', 'service', 'subService', 'address'])
            ->whereIn('status', ['Kerja Dalam Proses', 'Pembayaran Berjaya'])
            ->whereNotNull('approved_date')
            ->whereNotNull('approved_time')
            ->get();

        // Map the data for FullCalendar
        $formattedBookings = $bookings->map(function ($booking) {
            return [
                'title' => $booking->service->name,
                'start' => $booking->approved_date,
                'booking_id' => $booking->id, // Include booking ID
            ];
        });

        return response()->json($formattedBookings);
    }
}
