<?php

namespace App\Http\Controllers;

use App\Models\Booking;
use App\Models\Payment;
use App\Models\Quotation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Tarsoft\Toyyibpay\Toyyibpay;

class ToyyibpayController extends Controller
{
    public function getBankFPX()
    {
        $toyyibpay = app('Toyyibpay');
        $data = $toyyibpay->getBanksFPX();

        dd($data);
    }

    //Function Create Bill
    public function createPayment($bookingId, $quotationId)
    {
        // Retrieve the booking and quotation data from the database
        $booking = Booking::with(['user', 'service', 'subService', 'address'])->findOrFail($bookingId);
        $quotation = Quotation::where('booking_id', $bookingId)->firstOrFail();

        // Resolve the Toyyibpay service
        $toyyibpay = app('Toyyibpay');

        // Retrieve configuration values
        $redirect_uri = config('toyyibpay.redirect_uri');

        $code = config('toyyibpay.code'); // Category code
        // $client_secret = config('toyyibpay.client_secret'); //Secret key

        $amount = $booking->total_payment * 100;


        $bill_object = [
            'billName' => 'Bayaran Tempahan',
            'billDescription' => 'Bayaran untuk ' . $booking->subService->name,
            'billPriceSetting' => 1,
            'billPayorInfo' => 1,
            'billAmount' => $amount,
            'billReturnUrl' => route('payment.return'), //route after complete payment
            'billCallbackUrl' => route('payment.callback'), // route send payment status
            'billExternalReferenceNo' => 'Bill-0' . $booking->id,
            'billTo' => $booking->user->name,
            'billEmail' => $booking->user->email,
            'billPhone' => $booking->user->phoneNum,
            'billPaymentChannel' => 0,
            'billContentEmail' => 'Terima kasih kerana membuat pembayaran untuk perkhidmatan pembaikan rumah!"',
        ];

        // Call the ToyyibPay service to create the bill
        $data = $toyyibpay->createBill($code, (object)$bill_object); //array data convert to object

        // Redirect to ToyyibPay with the BillCode to complete payment
        $bill_code = $data[0]->BillCode;

        $redirect = $toyyibpay->billPaymentLink($bill_code);

        return redirect($redirect);
    }

    //function to retun to the website
    public function return(Request $request)
    {
        // Retrieve the GET data from ToyyibPay
        $data = $request->only([
            'status_id', // Payment status (1=success, 2=pending, 3=fail, 4=pending)
            'billcode',  // Bill code
            'order_id',  // External reference number
        ]);

        // Log the data for debugging (optional)
        Log::info('ToyyibPay Return Data: ', $data);

        // Validate the required fields
        if (!isset($data['order_id'], $data['status_id'])) {
            Log::error('ToyyibPay Return: Missing required data.');
            return redirect()->route('payment.display', ['id' => null])->with('error', 'Maklumat pembayaran tidak lengkap.');
        }

        // Extract booking ID from the order_id
        $bookingId = ltrim($data['order_id'], 'Bill-');
        $booking = Booking::find($bookingId);

        if ($booking) {
            // Ensure status_id is treated as an integer
            $statusId = (int) $data['status_id'];

            // Map ToyyibPay status_id to your booking/payment status
            $status = match ($statusId) {
                1 => 'successful',  // Successful transaction
                2, 4 => 'pending',  // Pending transaction
                3 => 'failed',      // Unsuccessful transaction
                default => 'unknown', // Catch any unexpected status
            };

            $amount = $booking->total_payment;

            // Create or update payment record
            $payment = Payment::create([
                'booking_id' => $booking->id,
                'bill_code' => $data['billcode'],
                'amount' => $amount, // Assumes amount is stored in booking
                'status' => $status,
                'reason' => $status === 'failed' ? 'Payment unsuccessful' : null, // Optional reason
                'transaction_time' => now(), // Current timestamp
            ]);

            // Update the booking status
            if ($status === 'successful') {
                $booking->status = 'Pembayaran Berjaya';
            } elseif ($status === 'failed') {
                $booking->status = 'Pembayaran Gagal';
            } else {
                $booking->status = 'Pembayaran Tidak Selesai';
            }
            $booking->save();

            Log::info("Payment recorded for Booking ID {$booking->id}: ", $payment->toArray());

            // Redirect with appropriate message
            $message = match ($status) {
                'successful' => 'Pembayaran anda telah berjaya.',
                'pending' => 'Pembayaran anda sedang diproses.',
                'failed' => 'Pembayaran anda gagal.',
                default => 'Status pembayaran tidak diketahui.',
            };

            $sessionKey = match ($status) {
                'successful' => 'success',
                'failed' => 'error',
                'pending' => 'info',
                default => 'warning',
            };

            return redirect()->route('payment.display', ['id' => $booking->id])->with($sessionKey, $message);
        }

        // Handle case where booking is not found
        Log::error("Booking not found for ID: {$bookingId}");
        return redirect()->route('payment.display', ['id' => null])->with('error', 'Tempahan tidak dijumpai.');
    }



    //function for toyyibPay to send bil status either fail or success
    public function callback(Request $request)
    {
        // Retrieve the POST data from ToyyibPay
        $data = $request->only([
            'refno',            // Payment reference number
            'status',           // Payment status (1=success, 2=pending, 3=fail)
            'reason',           // Reason for the status
            'billcode',         // Bill code
            'order_id',         // External reference number
            'amount',           // Payment amount (in cents)
            'transaction_time', // Transaction date and time
        ]);

        // Log the data for debugging (optional)
        Log::info('ToyyibPay Callback Data: ', $data);

        // // Find the booking using the order_id
        // $bookingId = ltrim($data['order_id'], 'Bil-'); // Extract the booking ID
        // $booking = Booking::find($bookingId);

        // if ($booking) {
        //     // Convert amount from cents to decimal
        //     $amount = $data['amount'] / 100;

        //     // Store payment details in the payments table
        //     $booking->payments()->create([
        //         'payment_reference' => $data['refno'],
        //         'payment_status' => $data['status'] == 1 ? 'paid' : ($data['status'] == 3 ? 'failed' : 'pending'),
        //         'reason' => $data['reason'],
        //         'amount' => $amount,
        //         'transaction_time' => $data['transaction_time'],
        //     ]);

        //     // Optionally update the booking's payment status
        //     $booking->payment_status = $data['status'] == 1 ? 'paid' : 'unpaid';
        //     $booking->save();
        // }

        // Respond to ToyyibPay to acknowledge the callback
        // return response('OK', 200);
    }


    // public function billPaymentLink($bill_code)
    // {
    //     // Assuming `app('Toyyibpay')` is a configured service
    //     $toyyibpay = app('Toyyibpay');

    //     $data = $toyyibpay->billPaymentLink($bill_code);


    //     return redirect($data);
    // }



}
