<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = ['name'];

    public function subServices()
    {
        return $this->hasMany(SubService::class); //parent to SubService
    }

    public function bookings()
    {
        return $this->hasMany(Booking::class);
    }
}
