<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Connects booking to a user
            $table->foreignId('service_id')->constrained()->onDelete('cascade');
            $table->foreignId('sub_service_id')->constrained()->onDelete('cascade');
            $table->foreignId('address_id')->constrained('addresses')->onDelete('cascade'); // Included here
            $table->enum('parts', ['Ya', 'Tidak'])->default('Tidak');
            $table->integer('unit')->default(1);
            $table->date('date');
            $table->time('time');
            $table->date('alt_date')->nullable();
            $table->time('alt_time')->nullable();
            $table->text('remark')->nullable();
            $table->string('proof_damage')->nullable(); // store image name or path
            $table->date('approved_date')->nullable();
            $table->time('approved_time')->nullable();
            $table->string('reject_reason')->nullable();
            $table->string('status')->default('Hantar');
            $table->string('rejection_reason')->nullable();
            $table->decimal('total_payment', 10, 2)->default(0.00);
            $table->timestamps();
    
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
