<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id(); // Primary key for the invoice
            $table->foreignId('booking_id')->constrained('bookings')->onDelete('cascade'); // Foreign key for booking
            $table->foreignId('payment_id')->constrained('payments')->onDelete('cascade'); // Foreign key for payment
            $table->decimal('amount', 10, 2); // Add an amount column if needed
            $table->timestamps(); // Created and updated timestamps
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
