@extends('layouts.baseAdmin')

@section('title', 'Tempah Servis')

@section('content')


    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg position-sticky mt-4 top-1 px-0 mx-4 shadow-none border-radius-xl z-index-sticky"
        id="navbarBlur" data-scroll="true">
        <div class="container-fluid py-1 px-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
                    <li class="breadcrumb-item text-sm">
                        <a class="opacity-3 text-dark" href="javascript:;">
                            <svg width="12px" height="12px" class="mb-1" viewBox="0 0 45 40" version="1.1"
                                xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                <title>Tempah Servis </title>
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <g transform="translate(-1716.000000, -439.000000)" fill="#252f40" fill-rule="nonzero">
                                        <g transform="translate(1716.000000, 291.000000)">
                                            <g transform="translate(0.000000, 148.000000)">
                                                <path
                                                    d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z">
                                                </path>
                                                <path
                                                    d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z">
                                                </path>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </a>
                    </li>
                    <li class="breadcrumb-item text-sm"><a class="opacity-5 text-dark"
                            href="{{ route('booking.list') }}">Tempah Servis</a></li>
                    <li class="breadcrumb-item text-sm text-dark active" aria-current="page">Pengesahan Tempah Servis</li>
                </ol>
                <h6 class="font-weight-bolder mb-0">Pengesahan Tempah Servis</h6>
            </nav>
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link text-body p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Type here...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        <form action="{{ route('logout') }}" method="POST" style="display:inline;">
                            @csrf
                            <button type="submit" class="nav-link text-body font-weight-bold px-0"
                                style="background: none; border: none;">
                                <i class="fa fa-user me-sm-1"></i>
                                <span class="d-sm-inline d-none">Log Keluar</span>
                            </button>
                        </form>
                    </li>
                    <li class="nav-item d-xl-none ps-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-body p-0" id="iconNavbarSidenav">
                            <div class="sidenav-toggler-inner">
                                <i class="sidenav-toggler-line"></i>
                                <i class="sidenav-toggler-line"></i>
                                <i class="sidenav-toggler-line"></i>
                            </div>
                        </a>
                    </li>
                    <li class="nav-item px-3 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-body p-0">
                            <i class="fa fa-cog fixed-plugin-button-nav cursor-pointer"></i>
                        </a>
                    </li>
                    <li class="nav-item dropdown pe-2 d-flex align-items-center">
                        <a href="javascript:;" class="nav-link text-body p-0" id="dropdownMenuButton"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="fa fa-bell cursor-pointer"></i>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end px-2 py-3 me-sm-n4" aria-labelledby="dropdownMenuButton">
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/team-2.jpg" class="avatar avatar-sm  me-3 "
                                                alt="user image">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New message</span> from Laur
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                13 minutes ago
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li class="mb-2">
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="my-auto">
                                            <img src="../../assets/img/small-logos/logo-spotify.svg"
                                                class="avatar avatar-sm bg-gradient-dark  me-3 " alt="logo spotify">
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                <span class="font-weight-bold">New album</span> by Travis Scott
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                1 day
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item border-radius-md" href="javascript:;">
                                    <div class="d-flex py-1">
                                        <div class="avatar avatar-sm bg-gradient-secondary  me-3  my-auto">
                                            <svg width="12px" height="12px" viewBox="0 0 43 36" version="1.1"
                                                xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <title>credit-card</title>
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <g transform="translate(-2169.000000, -745.000000)" fill="#FFFFFF"
                                                        fill-rule="nonzero">
                                                        <g transform="translate(1716.000000, 291.000000)">
                                                            <g transform="translate(453.000000, 454.000000)">
                                                                <path class="color-background"
                                                                    d="M43,10.7482083 L43,3.58333333 C43,1.60354167 41.3964583,0 39.4166667,0 L3.58333333,0 C1.60354167,0 0,1.60354167 0,3.58333333 L0,10.7482083 L43,10.7482083 Z"
                                                                    opacity="0.593633743"></path>
                                                                <path class="color-background"
                                                                    d="M0,16.125 L0,32.25 C0,34.2297917 1.60354167,35.8333333 3.58333333,35.8333333 L39.4166667,35.8333333 C41.3964583,35.8333333 43,34.2297917 43,32.25 L43,16.125 L0,16.125 Z M19.7083333,26.875 L7.16666667,26.875 L7.16666667,23.2916667 L19.7083333,23.2916667 L19.7083333,26.875 Z M35.8333333,26.875 L28.6666667,26.875 L28.6666667,23.2916667 L35.8333333,23.2916667 L35.8333333,26.875 Z">
                                                                </path>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </svg>
                                        </div>
                                        <div class="d-flex flex-column justify-content-center">
                                            <h6 class="text-sm font-weight-normal mb-1">
                                                Payment successfully completed
                                            </h6>
                                            <p class="text-xs text-secondary mb-0">
                                                <i class="fa fa-clock me-1"></i>
                                                2 days
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>


    <section style="background: #f6f9ff;">
        <div class="container center-container">
            @error('approved_datetime')
                <div class="text-danger mt-2">{{ $message }}</div>
            @enderror

            <div class="row justify-content-center w-100">
                <div class="card m-4 medium-card">
                    <div class="card-header pb-0 p-3">
                        <h3>Maklumat Servis</h3>
                    </div>
                    <div class="card-body p-4">
                        <!-- Booking Details Section -->
                        <div class="mb-3">
                            <label class="form-label font-weight-bold">Pilihan Servis:</label>
                            <p>{{ $booking->subService->name }}</p>
                        </div>
                        <hr>
                        <div class="section-title">
                            <h5><strong>Maklumat Alat Ganti & Unit</strong></h5>
                        </div>
                        <hr>

                        <!-- Parts & Units Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Adakah anda sudah mempunyai alat
                                    ganti?</label>
                                <p>{{ $booking->parts }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Bilangan Unit:</label>
                                <p>{{ $booking->unit }}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="section-title">
                            <h5><strong>Tarikh & Masa</strong></h5>
                        </div>
                        <hr>

                        <!-- Date & Time Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Tarikh Pilihan:</label>
                                <p>{{ $booking->date ? $booking->date->format('d/m/Y') : '-' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Masa Pilihan:</label>
                                <p>{{ $booking->time ? $booking->time->format('H:i') : '-' }}</p>
                            </div>
                        </div>

                        <!-- Alternative Date & Time Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Tarikh Alternatif:</label>
                                <p>{{ $booking->alt_date ? $booking->alt_date->format('d/m/Y') : '-' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Masa Alternatif:</label>
                                <p>{{ $booking->alt_time ? $booking->alt_time->format('H:i') : '-' }}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="section-title">
                            <h5><strong>Alamat</strong></h5>
                        </div>
                        <hr>

                        <!-- Address Section -->
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Alamat Baris 1:</label>
                                <p>{{ $booking->address->address_line1 ?? '-' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Alamat Baris 2:</label>
                                <p>{{ $booking->address->address_line2 ?? '-' }}</p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Bandar:</label>
                                <p>{{ $booking->address->city ?? '-' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label font-weight-bold">Poskod:</label>
                                <p>{{ $booking->address->postcode ?? '-' }}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="section-title">
                            <h5><strong>Bukti Kerosakan & Catatan</strong></h5>
                        </div>
                        <hr>

                        <!-- Proof of Damage Section -->
                        <div class="mb-3">
                            <label class="form-label font-weight-bold">Bukti Kerosakan:</label>
                            @if ($booking->proof_damage)
                                <div>
                                    <!-- Link for image popup -->
                                    <a href="{{ asset('storage/' . $booking->proof_damage) }}" data-bs-toggle="modal"
                                        data-bs-target="#proofDamageModal">
                                        <img src="{{ asset('storage/' . $booking->proof_damage) }}" alt="Proof of Damage"
                                            style="max-width: 200px; max-height: 200px; margin-bottom: 10px; cursor: pointer;">
                                    </a>
                                </div>

                                <!-- Modal for image popup -->
                                <div class="modal fade" id="proofDamageModal" tabindex="-1"
                                    aria-labelledby="proofDamageModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="proofDamageModalLabel">Bukti Kerosakan
                                                </h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                    aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body text-center">
                                                <img src="{{ asset('storage/' . $booking->proof_damage) }}"
                                                    alt="Proof of Damage" style="max-width: 100%; height: auto;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @else
                                <p class="text-muted">No proof of damage uploaded.</p>
                            @endif
                        </div>


                        <!-- Remarks Section -->
                        <div class="mb-3">
                            <label class="form-label font-weight-bold">Catatan:</label>
                            <p>{{ $booking->remark }}</p>
                        </div>
                        <hr>

                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-between">
                            <button type="button" class="btn btn-danger shadow" data-bs-toggle="modal"
                                data-bs-target="#exampleModalReject">
                                Tolak
                            </button>
                            <button type="submit" class="btn btn-warning text-white shadow" data-bs-toggle="modal"
                                data-bs-target="#approveModal">
                                Terima
                            </button>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- Approve Modal -->
        <div class="modal fade" id="approveModal" tabindex="-1" aria-labelledby="approveModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="approveModalLabel">Sahkan Tempahan</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="POST" action="{{ route('booking.approve.submit', $booking->id) }}">
                        @csrf
                        <div class="modal-body">
                            <p><strong>Pilih tarikh dan masa untuk disahkan:</strong></p>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="approved_slot" id="primarySlot"
                                    value="{{ $booking->date }}|{{ $booking->time }}" required>
                                <label class="form-check-label" for="primarySlot">
                                    {{ $booking->date ? $booking->date->format('d/m/Y') : '-' }} -
                                    {{ $booking->time ? $booking->time->format('H:i') : '-' }}
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="radio" name="approved_slot" id="altSlot"
                                    value="{{ $booking->alt_date }}|{{ $booking->alt_time }}">
                                <label class="form-check-label" for="altSlot">
                                    {{ $booking->alt_date ? $booking->alt_date->format('d/m/Y') : '-' }} -
                                    {{ $booking->alt_time ? $booking->alt_time->format('H:i') : '-' }}
                                </label>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                            <button type="submit" class="btn btn-warning text-white">Sahkan</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Rejection Modal -->
        <div class="modal fade" id="exampleModalReject" tabindex="-1" aria-labelledby="exampleModalRejectTitle"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <form method="POST" id="rejectForm" action="{{ route('booking.reject', ['id' => $booking->id]) }}">
                        @csrf
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalRejectTitle">Alasan Penolakkan</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="reject_reason" class="form-label">Alasan</label>
                                <textarea class="form-control" id="reject_reason" name="reject_reason" required></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                            <button type="submit" class="btn btn-warning">Hantar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </section>

    <script>
        document.getElementById('rejectForm').addEventListener('submit', function(e) {
            const reason = document.getElementById('reject_reason').value.trim();
            if (!reason) {
                e.preventDefault();
                alert('Sila masukkan alasan untuk penolakan.');
            }
        });
    </script>

@endsection
