@extends($layout)

@section('title', 'Invois')

@section('content')

    <!-- Nucleo Icons -->
    {{-- <link href="{{ asset('assets/css/nucleo-icons.css') }}" rel="stylesheet" />
    <link href="{{ asset('assets/css/nucleo-svg.css') }}" rel="stylesheet" />
    <!-- Font Awesome Icons -->
    <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
    <link href="{{ asset('assets/css/nucleo-svg.css') }}" rel="stylesheet" />
    <!-- CSS Files -->
    <link id="pagestyle" href="{{ asset('assets/css/soft-ui-dashboard.css?v=1.0.3') }}" rel="stylesheet" /> --}}

    <!-- Navbar -->
    <nav class="navbar navbar-main navbar-expand-lg position-sticky mt-4 top-1 px-0 mx-4 shadow-none border-radius-xl z-index-sticky"
        id="navbarBlur" data-scroll="true">
        <div class="container-fluid py-1 px-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb bg-transparent mb-0 pb-0 pt-1 px-0 me-sm-6 me-5">
                    <li class="breadcrumb-item text-sm">
                        <a class="opacity-3 text-dark" href="javascript:;">
                            <svg width="12px" height="12px" class="mb-1" viewBox="0 0 45 40" version="1.1"
                                xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                <title>shop </title>
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                    <g transform="translate(-1716.000000, -439.000000)" fill="#252f40" fill-rule="nonzero">
                                        <g transform="translate(1716.000000, 291.000000)">
                                            <g transform="translate(0.000000, 148.000000)">
                                                <path
                                                    d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z">
                                                </path>
                                                <path
                                                    d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z">
                                                </path>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </a>
                    </li>
                    {{-- <li class="breadcrumb-item text-sm"><a class="opacity-5 text-dark" href="javascript:;">Pages</a></li> --}}
                    <li class="breadcrumb-item text-sm text-dark active" aria-current="page">Invois</li>
                </ol>
                <h6 class="font-weight-bolder mb-0">Invois</h6>
            </nav>
            <div class="sidenav-toggler sidenav-toggler-inner d-xl-block d-none ">
                <a href="javascript:;" class="nav-link text-body p-0">
                    <div class="sidenav-toggler-inner">
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                        <i class="sidenav-toggler-line"></i>
                    </div>
                </a>
            </div>
            <div class="collapse navbar-collapse mt-sm-0 mt-2 me-md-0 me-sm-4" id="navbar">
                <div class="ms-md-auto pe-md-3 d-flex align-items-center">
                    <div class="input-group">
                        <span class="input-group-text text-body"><i class="fas fa-search" aria-hidden="true"></i></span>
                        <input type="text" class="form-control" placeholder="Taip disini...">
                    </div>
                </div>
                <ul class="navbar-nav  justify-content-end">
                    <li class="nav-item d-flex align-items-center">
                        <form action="{{ route('logout') }}" method="POST" style="display:inline;">
                            @csrf
                            <button type="submit" class="nav-link text-body font-weight-bold px-0"
                                style="background: none; border: none;">
                                <i class="fa fa-user me-sm-1"></i>
                                <span class="d-sm-inline d-none">Log Keluar</span>
                            </button>
                        </form>
                    </li>
                </ul>
            </div>
        </div>
    </nav><!-- End Navbar -->

    <section id="starter-section" class="starter-section section" style="background: #f6f9ff;">

        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <!-- Card header -->
                        <div class="card-header pb-0">
                            <div class="d-lg-flex">
                                <div>
                                    <h3 class="mb-0">Senarai Invois</h3>
                                </div>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-0">
                            <div class="table-responsive">
                                <table class="table table-flush" id="products-list">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>ID</th>
                                            <th>Nama</th>
                                            <th>Servis</th>
                                            <th>Tarikh</th>
                                            <th>Status</th>
                                            <th>Tindakan</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if (isset($bookings) && $bookings->count() > 0)
                                            @foreach ($bookings as $booking)
                                                <tr>
                                                    <td>{{ $booking->id }}</td>
                                                    <td>{{ $booking->user->name ?? 'N/A' }}</td>
                                                    <td>
                                                        {{ $booking->service->name ?? 'N/A' }}
                                                        @if ($booking->subService)
                                                            ({{ $booking->subService->name ?? 'N/A' }})
                                                        @endif
                                                    </td>
                                                    <td>{{ $booking->approved_date ? $booking->approved_date->format('d/m/Y') : 'N/A' }}
                                                    </td>
                                                    <td>
                                                        @if ($booking->status == 'Kerja Dalam Proses')
                                                            <span
                                                                class="badge badge-info badge-sm">{{ $booking->status }}</span>
                                                        @else
                                                            <span
                                                                class="badge badge-success badge-sm">{{ $booking->status }}</span>
                                                        @endif
                                                    </td>
                                                    <td class="text-sm">
                                                        @php
                                                            $route =
                                                                auth()->user()->role === 'admin'
                                                                    ? 'invoice.display'
                                                                    : 'invoice.view';
                                                        @endphp

                                                        @if ($booking->status === 'Kerja Dalam Proses')
                                                            <!-- "Papar" button (disabled) -->
                                                            <a href="#" class="disabled-link" data-bs-toggle="tooltip"
                                                                data-bs-original-title="Tiada Invois">
                                                                <i class="fas fa-eye text-secondary m-2"></i>
                                                            </a>
                                                            <!-- "Kemaskini" button -->
                                                            <a href="#" data-bs-toggle="modal"
                                                                data-bs-target="#completedModal-{{ $booking->id }}"
                                                                title="Kemaskini Status">
                                                                <i class="fas fa-edit text-dark m-2"></i>
                                                            </a>
                                                        @else
                                                            <!-- "Papar" button -->
                                                            <a href="{{ route($route, ['id' => $booking->id]) }}"
                                                                data-bs-toggle="tooltip" data-bs-original-title="Papar">
                                                                <i class="fas fa-eye text-dark m-2"></i>
                                                            </a>
                                                            <!-- "Kemaskini" button (disabled) -->
                                                            <a href="#" class="disabled-link" data-bs-toggle="tooltip"
                                                                data-bs-original-title="Sudah Kemaskini">
                                                                <i class="fas fa-edit text-secondary m-2"></i>
                                                            </a>
                                                        @endif
                                                    </td>

                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="6" class="text-center">Tiada tempahan ditemui.</td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal for each booking -->
            @foreach ($bookings as $booking)
                <div id="completedModal-{{ $booking->id }}" class="modal fade" tabindex="-1" role="dialog"
                    aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Kerja Selesai</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <p class="text-center">
                                    Adakah anda ingin kemaskini status tempahan
                                    <br> kepada <span class="text-success text-start"><b>Selesai</b></span>?
                                </p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Tidak</button>

                                <!-- Form for the specific booking -->
                                @php
                                    $routeName = auth()->user()->role === 'admin' ? 'invoice.create' : 'invoice.add';
                                @endphp

                                <form action="{{ route($routeName, ['id' => $booking->id]) }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="payment_id"
                                        value="{{ $booking->payments->last()->id }}">
                                    @if (auth()->user()->role === 'admin')
                                        <button type="submit" class="btn btn-warning mt-1">Selesaikan & Cipta
                                            Invois</button>
                                    @else
                                        <button type="submit" class="btn btn-success mt-1">Selesaikan & Cipta
                                            Invois</button>
                                    @endif

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach


    </section>


    <!--   Core JS Files   -->
    <script src="{{ asset('assets/js/core/popper.min.js') }}"></script>
    <script src="{{ asset('assets/js/core/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/perfect-scrollbar.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/smooth-scrollbar.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/datatables.js') }}"></script>


    <!-- Kanban scripts -->
    <script src="{{ asset('assets/js/plugins/dragula/dragula.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/jkanban/jkanban.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/multistep-form.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/choices.min.js"') }}"></script>
    <script src="{{ asset('assets/js/plugins/sweetalert.min.js') }}"></script>

    <script>
        $(function() {
            $('[data-bs-toggle="tooltip"]').tooltip()
        })
    </script>

    <script>
        if (document.getElementById('products-list')) {
            const dataTableSearch = new simpleDatatables.DataTable("#products-list", {
                searchable: true,
                fixedHeight: false,
                perPage: 7
            });

            document.querySelectorAll(".export").forEach(function(el) {
                el.addEventListener("click", function(e) {
                    var type = el.dataset.type;

                    var data = {
                        type: type,
                        filename: "soft-ui-" + type,
                    };

                    if (type === "csv") {
                        data.columnDelimiter = "|";
                    }

                    dataTableSearch.export(data);
                });
            });
        };
    </script>

    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>

@endsection
