@extends('layouts.base')

@section('title', 'Tempah Sekarang')

@section('content')


<!-- Nucleo Icons -->
<link href="{{ asset('assets/css/nucleo-icons.css') }}" rel="stylesheet" />
<link href="{{ asset('assets/css/nucleo-svg.css') }}" rel="stylesheet" />
<!-- Font Awesome Icons -->
<script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
<link href="{{ asset('assets/css/nucleo-svg.css') }}" rel="stylesheet" />
<!-- CSS Files -->
<link id="pagestyle" href="{{ asset('assets/css/soft-ui-dashboard.css?v=1.0.3') }}" rel="stylesheet" />

<!-- Page Title -->
<div class="page-title" data-aos="fade" style="background-image: url({{ asset('assets/img/page-title-bg.jpg') }});">
    <div class="container position-relative">
        <h2 class="text-white">Tempah Sekarang</h2>
        <nav class="breadcrumbs">
            <ol>
                <li><a href="{{ route('user.homepage') }}" style="color: #feb900">Laman Utama</a></li>
                <li class="current">Servis > Tempah Sekarang</li>
            </ol>
        </nav>
    </div>
</div><!-- End Page Title -->

<!-- Starter Section Section -->
<section id="starter-section" class="starter-section section" style="background: #f6f9ff;">

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12 text-center">
                {{-- <h3 class="mt-5">Build Your Profile</h3>
                    <h5 class="text-secondary font-weight-normal">This information will let us know more about you.</h5> --}}
                <div class="multisteps-form mb-5">
                    <!--progress bar-->
                    <div class="row">
                        <div class="col-12 col-lg-8 mx-auto my-5">
                            <div class="multisteps-form__progress">
                                <button class="multisteps-form__progress-btn js-active " type="button" title="Sekarang"
                                    style="color: #feb900">
                                    <span style="color: darkgrey">Servis</span>
                                </button>
                                <button class="multisteps-form__progress-btn" type="button" title="Maklumat"
                                    style="color: #feb900">
                                    <span style="color: darkgrey">Maklumat</span>
                                </button>
                                <button class="multisteps-form__progress-btn" type="button" title="Alamat"
                                    style="color: #feb900">
                                    <span style="color: darkgrey">Alamat</span>
                                </button>
                                <button class="multisteps-form__progress-btn" type="button" title="Ringkasan"
                                    style="color: #feb900">
                                    <span style="color: darkgrey">Ringkasan</span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <!--form panels-->
                    <div class="row">
                        <div class="col-12 col-lg-8 m-auto">
                            <form action="{{ route('booking.store') }}" method="POST" class="multisteps-form__form"
                                enctype="multipart/form-data">
                                @csrf
                                <!--single form panel (Service)-->
                                <div class="card multisteps-form__panel p-3 border-radius-xl bg-white js-active"
                                    data-animation="FadeIn">
                                    <div class="row text-center">
                                        <div class="col-10 mx-auto">
                                            <h4 class="font-weight-normal">Senarai Servis</h4>
                                            <p>Sila pilih servis yang anda kehendaki</p>
                                        </div>
                                    </div>

                                    <div class="multisteps-form__content">
                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label for="service">Servis</label>
                                                <select name="service" id="service" class="form-control"
                                                    onchange="updateSubServices()" required>
                                                    <option value="">Pilih Servis</option>
                                                    @foreach ($services as $service)
                                                    <option value="{{ $service->id }}"
                                                        data-name="{{ $service->name }}">{{ $service->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label for="sub_service">Pilihan Servis</label>
                                                <select name="sub_service" id="sub_service" class="form-control"
                                                    required>
                                                    <option value="">Sila pilih servis utama terlebih dahulu
                                                    </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label for="parts">Adakah anda sudah mempunyai alat ganti?</label>
                                                <select name="parts" id="parts" class="form-control" required>
                                                    <option value="Ya"
                                                        {{ old('parts') == 'Ya' ? 'selected' : '' }}>Ya</option>
                                                    <option value="Tidak"
                                                        {{ old('parts') == 'Tidak' ? 'selected' : '' }}>Tidak</option>
                                                </select>
                                            </div>

                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label for="unit">Bilangan Unit</label>
                                                <input type="number" id="unit" name="unit"
                                                    class="multisteps-form__input form-control" placeholder=""
                                                    min="1" value="1">
                                            </div>

                                        </div>

                                        <div class="button-row d-flex mt-4">
                                            <button class="btn btn-warning ms-auto mb-0 js-btn-next text-black"
                                                type="button" title="Next">Seterusnya</button>
                                        </div>
                                    </div>


                                </div>
                                <!--single form panel (Information)-->
                                <div class="card multisteps-form__panel p-3 border-radius-xl bg-white"
                                    data-animation="FadeIn">
                                    <div class="row text-center">
                                        <div class="col-10 mx-auto">
                                            <h4 class="font-weight-normal">Maklumat Kerosakkan</h4>
                                            <p>Sila nyatakan maklumat kerosakkan yang dialami oleh anda</p>
                                        </div>
                                    </div>
                                    <div class="multisteps-form__content">

                                        <div class="row mt-3">
                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label>Tarikh Pilihan</label>
                                                <input type="date" name="date" id="date"
                                                    class="multisteps-form__input form-control" placeholder="">
                                            </div>


                                            <div class="col-md-6 mt-md-0 text-start">
                                                <label for="time">Masa Pilihan</label>
                                                <select name="time" id="time" class="form-control" required>
                                                    <!-- Time options will be populated dynamically -->
                                                </select>
                                            </div>

                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label>Tarikh Alternatif</label>
                                                <input type="date" name="alt_date" id="alt_date"
                                                    class="multisteps-form__input form-control" placeholder="">
                                            </div>

                                            <div class="col-md-6 mt-md-0 text-start">
                                                <label>Masa Alternatif</label>
                                                <select name="alt_time" id="alt_time" class="form-control">
                                                    <!-- Alternative time options will be populated dynamically -->
                                                </select>


                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label for="proofDamage">Bukti Kerosakkan</label>
                                                <input type="file" name="proof_damage" id="proofDamage"
                                                    accept="image/*,video/*"
                                                    class="multisteps-form__input form-control" placeholder="">
                                                <div id="proofPreview" style="margin-top: 10px;"></div>
                                                <!-- Preview container -->
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Catatan</label>
                                                <textarea name="remark" id="remark" class="multisteps-form__input form-control" rows="3"></textarea>
                                            </div>
                                        </div>

                                        <div class="button-row d-flex mt-4">
                                            <button class="btn bg-gradient-light mb-0 js-btn-prev" type="button"
                                                title="Kembali">Kembali</button>
                                            <button class="btn btn-warning ms-auto mb-0 js-btn-next text-black"
                                                type="button" type="button" title="Next">Seterusnya</button>
                                        </div>
                                    </div>
                                </div>
                                <!--single form panel (Address)-->
                                <div class="card multisteps-form__panel p-3 border-radius-xl bg-white"
                                    data-animation="FadeIn">
                                    <div class="row text-center">
                                        <div class="col-10 mx-auto">
                                            <h4 class="font-weight-normal">Alamat Rumah</h4>
                                            <p>Nyatakan maklumat mengenai alamat rumah anda</p>
                                        </div>
                                    </div>
                                    <div class="multisteps-form__content">
                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Alamat Baris 1</label>
                                                <input type="text" name="address_line1" id="address_line1"
                                                    class="multisteps-form__input form-control"
                                                    placeholder="76, Jalan Pak Samad">
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Alamat Baris 2</label>
                                                <input type="text" name="address_line2" id="address_line2"
                                                    class="multisteps-form__input form-control"
                                                    placeholder="Taman Bahagia">
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label>Bandar</label>
                                                <select name="city" id="city"
                                                    class="multisteps-form__input form-control">
                                                    {{-- <option value="Bandar Klang">Bandar Klang</option> --}}
                                                    <option value="Bukit Tinggi">Bukit Tinggi</option>
                                                    <option value="Pelabuhan Klang">Pelabuhan Klang</option>
                                                    <option value="Pandamaran">Pandamaran</option>
                                                    <option value="Taman Sri Andalas">Taman Sri Andalas</option>
                                                    <option value="Taman Sentosa">Taman Sentosa</option>
                                                    <option value="Taman Indah">Taman Indah</option>
                                                    <option value="Klang Utama">Klang Utama</option>
                                                    <option value="Teluk Gong">Teluk Gong</option>
                                                    <option value="Bandar Botanik">Bandar Botanik</option>

                                                </select>
                                            </div>

                                            <div class="col-md-6 mt-md-0 text-start">
                                                <label>Poskod</label>
                                                <input type="number" name="postcode" id="postcode"
                                                    class="multisteps-form__input form-control" placeholder="42000">
                                            </div>
                                        </div>

                                    </div>
                                    <div class="button-row d-flex mt-4">
                                        <button class="btn bg-gradient-light mb-0 js-btn-prev" type="button"
                                            title="Prev">Kembali</button>
                                        <button class="btn btn-warning ms-auto mb-0 js-btn-next text-black"
                                            type="button" type="button" title="Next">Seterusnya</button>
                                    </div>
                                </div>

                                <!--single form panel (Preview)-->
                                <div class="card multisteps-form__panel p-3 border-radius-xl bg-white"
                                    data-animation="FadeIn">
                                    <div class="row text-center">
                                        <div class="col-10 mx-auto">
                                            <h4 class="font-weight-normal">Ringkasan</h4>
                                            <p>Sila pastikan semua makulmat adalah tepat sebelum anda menekan butang
                                                <b>Hantar</b>
                                            </p>
                                        </div>
                                    </div>

                                    <div class="multisteps-form__content">
                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Servis</label>
                                                <input type="text" id="preview_service"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Servis Pilihan</label>
                                                <input type="text" id="preview_sub_service"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label>Adakah anda sudah mempunyai alat ganti?</label>
                                                <input type="text" id="preview_parts"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>

                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label>Bilangan Unit</label>
                                                <input type="text" id="preview_unit"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>
                                        </div>


                                        <div class="row mt-3">
                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label>Tarikh Pilihan</label>
                                                <input type="text" id="preview_date"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>

                                            <div class="col-md-6 mt-md-0 text-start">
                                                <label>Masa Pilihan</label>
                                                <input type="text" id="preview_time"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label>Tarikh Alternatif</label>
                                                <input type="text" id="preview_alt_date"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>

                                            <div class="col-md-6 mt-md-0 text-start">
                                                <label>Masa Alternatif</label>
                                                <input type="text" id="preview_alt_time"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Bukti Kerosakkan</label> <br>
                                                <a href="#" id="openPreviewModal" data-bs-toggle="modal"
                                                    data-bs-target="#previewModal"
                                                    style="text-decoration: underline; color: blue;">Lihat Bukti
                                                    Kerosakkan</a>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Catatan</label>
                                                <textarea type="text" id="preview_remark" class="multisteps-form__input form-control" disabled rows="3"></textarea>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Alamat Baris 1</label>
                                                <input type="text" id="preview_address_line1"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-start">
                                                <label>Alamat Baris 2</label>
                                                <input type="text" id="preview_address_line2"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>
                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-6 mt-4 mt-md-0 text-start">
                                                <label>Bandar</label>
                                                <input type="text" id="preview_city"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>

                                            <div class="col-md-6 mt-md-0 text-start">
                                                <label>Poskod</label>
                                                <input type="number" id="preview_postcode"
                                                    class="multisteps-form__input form-control" disabled>
                                            </div>

                                            <div class="mt-3 text-start">
                                                <small>
                                                    <span class="text-warning"><b>Nota:</b></span>
                                                    <i> Anggaran harga termasuk upah pemasangan / upah baikpulih</i>
                                                </small>
                                            </div>

                                        </div>

                                        <div class="row mt-3">
                                            <div class="col-md-12 mt-4 mt-md-0 text-end">
                                                <p style="color:dimgray;">Anggaran harga</p>
                                                <h4 id="priceDisplay"><b>RM 0.00</b></h4>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="button-row d-flex mt-4 col-12">
                                            <button class="btn bg-gradient-light mb-0 js-btn-prev" type="button"
                                                title="Kembali">Kembali</button>

                                            <button type="submit"
                                                class="btn btn-warning ms-auto mb-0 js-btn-next text-black">Hantar</button>

                                        </div>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for preview -->
    <div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="previewModalLabel">Bukti Kerosakkan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="modalPreviewContent"
                    style="text-align: center; max-height: 400px; overflow: auto;">
                    <p id="noProofModalMessage" style="color: dimgray;">Tiada fail dimuat naik.</p>
                    <div id="modalProofPreview" style="display: none;"></div>
                </div>
            </div>
        </div>
    </div>

</section>

<!--   Core JS Files   -->
<script src="{{ asset('assets/js/core/popper.min.js') }}"></script>
<script src="{{ asset('assets/js/core/bootstrap.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/perfect-scrollbar.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/smooth-scrollbar.min.js') }}"></script>
<!-- Kanban scripts -->
<script src="{{ asset('assets/js/plugins/dragula/dragula.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins/jkanban/jkanban.js') }}"></script>
<script src="{{ asset('assets/js/plugins/multistep-form.js') }}"></script>
<script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>


<script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
        var options = {
            damping: '0.5'
        }
        Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
</script>

<!-- script for upload image video -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        const proofDamageInput = document.getElementById("proofDamage");
        const modalProofPreview = document.getElementById("modalProofPreview");
        const noProofModalMessage = document.getElementById("noProofModalMessage");

        // Update the modal content when a file is uploaded
        proofDamageInput.addEventListener("change", function(event) {
            const file = event.target.files[0];

            if (file) {
                const fileType = file.type.split("/")[0]; // Determine if it's an image or video
                const fileURL = URL.createObjectURL(file);

                // Clear previous content
                modalProofPreview.innerHTML = "";

                if (fileType === "image") {
                    const img = document.createElement("img");
                    img.src = fileURL;
                    img.alt = "Preview Image";
                    img.style.maxWidth = "100%";
                    img.style.maxHeight = "300px";
                    modalProofPreview.appendChild(img);
                } else if (fileType === "video") {
                    const video = document.createElement("video");
                    video.src = fileURL;
                    video.controls = true;
                    video.style.maxWidth = "100%";
                    video.style.maxHeight = "300px";
                    modalProofPreview.appendChild(video);
                } else {
                    modalProofPreview.innerHTML =
                        "<p>Jenis fail tidak disokong. Sila muat naik imej atau video.</p>";
                }

                // Update visibility
                noProofModalMessage.style.display = "none";
                modalProofPreview.style.display = "block";
            } else {
                // Reset to no file uploaded
                modalProofPreview.innerHTML = "";
                modalProofPreview.style.display = "none";
                noProofModalMessage.style.display = "block";
            }
        });

        // Initialize the modal as empty on page load
        document.getElementById("openPreviewModal").addEventListener("click", function() {
            if (!proofDamageInput.files[0]) {
                modalProofPreview.innerHTML = "";
                modalProofPreview.style.display = "none";
                noProofModalMessage.style.display = "block";
            }
        });
    });
</script>


{{-- script for display sub service --}}
<script>
    const services = @json($services); // Pass PHP data to JavaScript

    function updateSubServices() {
        const serviceDropdown = document.getElementById('service');
        const subServiceDropdown = document.getElementById('sub_service');
        const priceDisplay = document.getElementById('priceDisplay');
        const unitInput = document.getElementById('unit');
        const partsDropdown = document.getElementById('parts');

        const serviceId = serviceDropdown.value;
        const selectedOption = serviceDropdown.options[serviceDropdown.selectedIndex];
        const selectedServiceName = selectedOption.getAttribute('data-name');

        subServiceDropdown.innerHTML = '<option value="">Sila pilih servis utama terlebih dahulu</option>';
        if (priceDisplay) {
            priceDisplay.innerHTML = '<b>RM 0.00</b>';
        }

        const selectedService = services.find(service => service.id == serviceId);

        if (selectedService && selectedService.sub_services.length > 0) {
            selectedService.sub_services.forEach(subService => {
                const option = document.createElement('option');
                option.value = subService.id;
                option.textContent = `${subService.name}`;
                subServiceDropdown.appendChild(option);
            });

            const updatePrice = () => {
                const subServiceId = subServiceDropdown.value;
                const selectedSubService = selectedService.sub_services.find(sub => sub.id == subServiceId);
                const unit = parseInt(unitInput.value) || 1;
                const partsValue = partsDropdown.value;

                if (priceDisplay && selectedSubService) {
                    const estimatePrice = parseFloat(selectedSubService.estimate_price);
                    const price = parseFloat(selectedSubService.price || 0);

                    let finalPrice;
                    if (partsValue === 'Ya') {
                        finalPrice = price;
                    } else if (unit > 2) {
                        finalPrice = (estimatePrice * unit) - price;
                    } else {
                        finalPrice = estimatePrice;
                    }

                    priceDisplay.innerHTML = `<b>RM ${finalPrice.toFixed(2)}</b>`;
                } else {
                    priceDisplay.innerHTML = '<b>RM 0.00</b>';
                }
            };

            subServiceDropdown.addEventListener('change', updatePrice);
            unitInput.addEventListener('input', updatePrice);
            partsDropdown.addEventListener('change', updatePrice);
        } else {
            subServiceDropdown.innerHTML = '<option value="">Tiada sub-servis tersedia</option>';
        }

        updateServiceFields(selectedServiceName);
    }

    document.addEventListener('DOMContentLoaded', () => {
        updateSubServices();

        const serviceDropdown = document.getElementById('service');
        serviceDropdown.addEventListener('change', updateSubServices);
    });
</script>

{{-- script for date and time --}}
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const dateInput = document.getElementById('date');
        const timeInput = document.getElementById('time');
        const altDateInput = document.getElementById('alt_date');
        const altTimeInput = document.getElementById('alt_time');

        // Function to disable past dates
        function disablePastDates(inputElement) {
            const today = new Date();
            today.setHours(0, 0, 0, 0); // Remove time part for accurate comparison
            const todayString = today.toISOString().split('T')[0]; // Format to YYYY-MM-DD
            inputElement.setAttribute('min', todayString);
        }

        // Disable past dates for both date inputs
        disablePastDates(dateInput);
        disablePastDates(altDateInput);

        dateInput.addEventListener('change', function() {
            const selectedDate = this.value;
            if (selectedDate) {
                fetchAvailableSlots(selectedDate, timeInput);
            }
        });

        altDateInput.addEventListener('change', function() {
            const selectedAltDate = this.value;
            if (selectedAltDate) {
                fetchAvailableSlots(selectedAltDate, altTimeInput);
            }
        });

        function fetchAvailableSlots(date, timeSelect) {
            fetch(`/bookings/available-slots?date=${date}`)
                .then(response => response.json())
                .then(data => {
                    if (data.timeSlots) {
                        populateTimeSlots(timeSelect, data.timeSlots);
                    }
                })
                .catch(error => console.error("Error fetching available slots:", error));
        }

        function populateTimeSlots(selectElement, timeSlots) {
            selectElement.innerHTML = '';
            timeSlots.forEach(slot => {
                const option = document.createElement('option');
                option.value = slot.time;
                option.textContent = slot.time;
                option.disabled = !slot.is_available;
                selectElement.appendChild(option);
            });
        }

        timeInput.addEventListener('change', function() {
            if (dateInput.value === altDateInput.value && timeInput.value === altTimeInput.value) {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'Masa pilihan dan masa alternatif tidak boleh sama pada tarikh yang sama.',
                    showConfirmButton: false,
                    timer: 4000,
                    timerProgressBar: true,
                });
                timeInput.value = '';
            }
        });

        altTimeInput.addEventListener('change', function() {
            if (dateInput.value === altDateInput.value && timeInput.value === altTimeInput.value) {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'error',
                    title: 'Masa pilihan dan masa alternatif tidak boleh sama pada tarikh yang sama.',
                    showConfirmButton: false,
                    timer: 4000,
                    timerProgressBar: true,
                });
                altTimeInput.value = '';
            }
        });
    });
</script>


{{-- display preview --}}
<script>
    document.addEventListener("DOMContentLoaded", function() {
        function updatePreview() {
            const service = document.getElementById('service');
            const subService = document.getElementById('sub_service');
            const parts = document.getElementById('parts');
            const unit = document.getElementById('unit');
            const date = document.getElementById('date');
            const time = document.getElementById('time');
            const altDate = document.getElementById('alt_date');
            const altTime = document.getElementById('alt_time');
            const remark = document.getElementById('remark');
            const addressLine1 = document.getElementById('address_line1');
            const addressLine2 = document.getElementById('address_line2');
            const city = document.getElementById('city');
            const postcode = document.getElementById('postcode');

            document.getElementById('preview_service').value = service.options[service.selectedIndex]?.text ||
                '';
            document.getElementById('preview_sub_service').value = subService.options[subService.selectedIndex]
                ?.text || '';
            document.getElementById('preview_parts').value = parts.options[parts.selectedIndex]?.text || '';
            document.getElementById('preview_unit').value = unit.value;
            document.getElementById('preview_date').value = date.value;
            document.getElementById('preview_time').value = time.value;
            document.getElementById('preview_alt_date').value = altDate.value;
            document.getElementById('preview_alt_time').value = altTime.value;
            document.getElementById('preview_remark').value = remark.value;
            document.getElementById('preview_address_line1').value = addressLine1.value;
            document.getElementById('preview_address_line2').value = addressLine2.value;
            document.getElementById('preview_city').value = city.value;
            document.getElementById('preview_postcode').value = postcode.value;
        }

        const formElements = document.querySelectorAll(
            "#service, #sub_service, #unit, #date, #time, #alt_date, #alt_time, #remark, #address_line1, #address_line2, #city, #postcode"
        );

        formElements.forEach(function(element) {
            element.addEventListener("input", updatePreview);
        });

        document.getElementById("service").addEventListener("change", () => {
            const serviceName = document.getElementById("service").options[document.getElementById(
                "service").selectedIndex]?.getAttribute('data-name') || '';
            updateServiceFields(serviceName);
            updatePreview();
        });

        updatePreview();
    });
</script>






<!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
<script src="{{ asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3') }}"></script>


@endsection