@extends('layouts.base')

@section('title', 'Tempahan')

@section('content')

    <!-- Nucleo Icons -->
    <link href="{{ asset('assets/css/nucleo-icons.css') }}" rel="stylesheet" />
    <link href="{{ asset('assets/css/nucleo-svg.css') }}" rel="stylesheet" />
    <!-- Font Awesome Icons -->
    <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
    <link href="{{ asset('assets/css/nucleo-svg.css') }}" rel="stylesheet" />
    <!-- CSS Files -->
    <link id="pagestyle" href="{{ asset('assets/css/soft-ui-dashboard.css?v=1.0.3') }}" rel="stylesheet" />


    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url({{ asset('assets/img/page-title-bg.jpg') }});">
        <div class="container position-relative">
            <h1 class="text-white">Maklumat Servis</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                    <li><a href="{{ route('booking.index') }}" style="color: #feb900">Servis</a></li>
                    <li class="current">Papar</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Starter Section Section -->
    <section style="background: #f6f9ff;">

        <div class="container center-container">
            <div class="row justify-content-center w-100">
                <div class="card m-4 medium-card">
                    <div class="card-header pb-0 p-3">
                        <h3>Maklumat Servis</h3>
                    </div>
                    <div class="card-body p-4">
                        <form>
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Servis</label>
                                        <input type="text" class="form-control form-control-lg"
                                            value="{{ $booking->service->name }}" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Pilihan Servis</label>
                                        <input type="text" class="form-control form-control-lg"
                                            value="{{ $booking->subService->name }}" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Adakah anda sudah mempunyai alat ganti?</label>
                                        <input type="text" class="form-control form-control-lg"
                                            value="{{ $booking->parts }}" disabled>
                                    </div>
                                </div>

                                <div class="col">
                                    <div class="form-group">
                                        <label>Bilangan Unit</label>
                                        <input type="text" class="form-control form-control-lg"
                                            value="{{ $booking->unit }}" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Tarikh Pilihan</label>
                                        <input class="form-control form-control-lg"
                                            value="{{ date('d-m-Y', strtotime($booking->date)) }}" type="text" disabled>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label>Masa Pilihan</label>
                                        <input class="form-control form-control-lg"
                                            value="{{ date('H:i', strtotime($booking->time)) }}" type="text" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Tarikh Alternatif</label>
                                        <input class="form-control form-control-lg"
                                            value="{{ date('d-m-Y', strtotime($booking->alt_date)) }}" type="text"
                                            disabled>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="form-group">
                                        <label>Masa Alternatif</label>
                                        <input class="form-control form-control-lg"
                                            value="{{ date('H:i', strtotime($booking->alt_time)) }}" type="text"
                                            disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Alamat Baris 1</label>
                                        <input type="text" class="form-control form-control-lg"
                                            value="{{ $booking->address->address_line1 }}" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Alamat Baris 2</label>
                                        <input type="text" class="form-control form-control-lg"
                                            value="{{ $booking->address->address_line2 }}" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Bandar</label>
                                        <input type="text" class="form-control form-control-lg"
                                            value="{{ $booking->address->city }}" disabled>
                                    </div>
                                </div>

                                <div class="col">
                                    <div class="form-group">
                                        <label>Poskod</label>
                                        <input type="number" class="form-control form-control-lg"
                                            value="{{ $booking->address->postcode }}" disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <label>Bukti Kerosakkan</label>
                                    @if ($booking->proof_damage)
                                        <div>
                                            <a href="#" data-bs-toggle="modal" data-bs-target="#proofModal">Lihat
                                                Bukti Kerosakkan</a> <!-- Trigger Modal -->
                                        </div>
                                    @else
                                        <p>No proof of damage uploaded.</p>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <div class="col">
                                    <div class="form-group">
                                        <label>Catatan</label>
                                        <textarea class="form-control form-control-lg" rows="3" disabled>{{ $booking->remark }}</textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="button-row d-flex mt-4 col-12">
                                    <button onclick="history.back()" class="btn bg-gradient-light mb-0 js-btn-prev"
                                        type="button" title="Kembali">Kembali</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="proofModal" tabindex="-1" aria-labelledby="proofModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="proofModalLabel">Bukti Kerosakkan</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        @php
                            $filePath = asset('storage/' . $booking->proof_damage);
                            $isVideo = in_array(pathinfo($filePath, PATHINFO_EXTENSION), ['mp4', 'mov', 'avi']);
                        @endphp

                        @if ($isVideo)
                            <video controls style="max-width: 100%; max-height: 400px;">
                                <source src="{{ $filePath }}"
                                    type="video/{{ pathinfo($filePath, PATHINFO_EXTENSION) }}">
                                Your browser does not support the video tag.
                            </video>
                        @else
                            <img src="{{ $filePath }}" alt="Proof of Damage"
                                style="max-width: 100%; max-height: 400px;">
                        @endif
                    </div>
                </div>
            </div>
        </div>


    </section>

    <!--   Core JS Files   -->
    <script src="{{ asset('assets/js/core/popper.min.js') }}"></script>
    <script src="{{ asset('assets/js/core/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/perfect-scrollbar.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/smooth-scrollbar.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/datatables.js') }}"></script>

    <!-- Kanban scripts -->
    <script src="{{ asset('assets/js/plugins/dragula/dragula.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/jkanban/jkanban.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/multistep-form.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/choices.min.js') }}"></script>

    <!-- Kanban scripts -->
    <script src="{{ asset('assets/js/plugins/dragula/dragula.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/jkanban/jkanban.js') }}"></script>

    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>

    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="{{ asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3') }}"></script>


@endsection
