<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Daftar Masuk'); ?></title>


    <!-- bootstrap css -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">

    

    <!-- Favicons -->
    <link rel="icon" href="<?php echo e(asset('assets/img/favicon.png')); ?> ">
    <link rel="apple-touch-ico" href="<?php echo e(asset('assets/img/apple-touch-icon.png')); ?> ">

    <!-- Fonts and Icons -->
    <link href="https://fonts.googleapis.com" rel="preconnect">
    <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
    <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">


    <!-- Main CSS File -->
    <link id="pagestyle" href= " <?php echo e(asset('assets/css/soft-ui-dashboard.css?v=1.0.3')); ?> " rel="stylesheet">

</head>

<body class="">
    <main class="main-content  mt-0">
        <section>
            <div class="page-header min-vh-100">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-4 col-lg-5 col-md-7 d-flex flex-column mx-lg-0 mx-auto">
                            <div class="card card-plain">
                                <div class="card-header pb-0 text-start">
                                    <h4 class="font-weight-bolder">Daftar Masuk</h4>
                                    <p class="mb-0">Masukkan maklumat yang dikehendaki untuk daftar masuk</p>
                                </div>
                                <div class="card-body">
                                    <form action="<?php echo e(route('register.save')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>

                                        <div class="mb-3">
                                            <input id="name" name="name" type="text"
                                                class="form-control form-control-lg" value="<?php echo e(old('name')); ?>"
                                                required autocomplete="name" autofocus placeholder="Nama">

                                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span style="color:red; font-size:10px"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-3">
                                            <input id="phoneNum" name="phoneNum" type="text"
                                                class="form-control form-control-lg" value="<?php echo e(old('phoneNum')); ?>"
                                                required autocomplete="phoneNum" autofocus placeholder="Nombor Telefon">

                                            <?php $__errorArgs = ['phoneNum'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span style="color:red; font-size:10px"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-3">
                                            <input id="email" name="email" type="email"
                                                class="form-control form-control-lg" value="<?php echo e(old('email')); ?>"
                                                required autocomplete="email" autofocus placeholder="Emel">

                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span style="color:red; font-size:10px"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="mb-3">
                                            <input id="password" type="password" class="form-control form-control-lg"
                                                name="password" required autocomplete="new-password"
                                                placeholder="Kata Laluan">

                                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span style="color:red; font-size:12px"><?php echo $message; ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                        </div>

                                        <div class="mb-3">
                                            <input id="password_confirmation" name="password_confirmation"
                                                type="password" class="form-control form-control-lg" required
                                                autocomplete="new-password" placeholder="Pengesahan Kata Laluan">

                                            <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span style="color:red; font-size:12px"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="row mb-3">
                                            <div class="text-center">
                                                <button type="submit"
                                                    class="btn btn-lg bg-gradient-warning btn-lg w-100 mt-4 mb-0">
                                                    Daftar Masuk
                                                </button>
                                            </div>
                                        </div>

                                        <div class="card-footer text-center pt-0 px-lg-2 px-1">
                                            <p class="mb-4 text-sm mx-auto">
                                                Sudah mempunyai akaun?
                                                <a href="<?php echo e(route('login')); ?>"
                                                    class="text-warning font-weight-bold">Log Masuk</a>
                                            </p>
                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>
                        <div
                            class="col-6 d-lg-flex d-none h-100 my-auto pe-0 position-absolute top-0 end-0 text-center justify-content-center flex-column">
                            <div
                                class="position-relative bg-gradient-warning h-100 m-3 px-7 border-radius-lg d-flex flex-column justify-content-center">
                                <img src="<?php echo e(asset('assets/img/pattern-lines.svg')); ?>" alt="pattern-lines"
                                    class="position-absolute opacity-4 start-0">
                                <div class="position-relative">
                                    <img class="max-width-400 w-100 position-relative z-index-2"
                                        src="<?php echo e(asset('assets/img/searchbar.png')); ?>" alt="chat-img">
                                </div>
                                <h4 class="mt-3 text-white font-weight-bolder">"Kemudahan anda, Keutamaan kami</h4>
                                <h4 class="text-white
                ">Sertai kami hari ini!</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <!--   Core JS Files   -->

    <script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>

    <!-- Kanban scripts -->
    <script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>
    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>
    <!-- Github buttons -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>
</body>

</html>
<?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/auth/register.blade.php ENDPATH**/ ?>