<?php $__env->startSection('title', 'Pembayaran'); ?>

<?php $__env->startSection('content'); ?>

<style>
    

    .green{
        color: rgb(15, 207, 143);
        font-weight: 680;
    }

    @media(max-width:567px){
        .mobile{
            padding-top: 40px;
        }
    }
</style>

 <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet">
 <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">



    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url(<?php echo e(asset('assets/img/page-title-bg.jpg')); ?>);">
        <div class="container position-relative">
            <h1 class="text-white">Pembayaran</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                    <li><a href="<?php echo e(route('booking.index')); ?>" style="color: #feb900">Servis > Senarai Tempahan</a></li>
                    <li class="current">Pembayaran</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Section -->
    

    <section style="background: #f6f9ff;">
        <div class="container rounded bg-white">
            <div class="row d-flex justify-content-center pb-5">
                <div class="col-sm-5 col-md-5 ml-1">
                    <div class="py-4 d-flex flex-row">
                        <h3 class="sitename">MyTukang<span style="color: #feb900">.</span></h3>
                    </div>
                    <h4 class="green">RM <?php echo e($quotation->booking->total_payment); ?></h4>
                    <h4><?php echo e($quotation->booking->subService->name); ?></h4>
            
                    <hr>

                    <div class="pt-2">
                        <div class="d-flex">
                        <p><b>No. Tempahan:</b> #<?php echo e($quotation->booking->id); ?></p>
                        </div>
                        <div class="d-flex">
                            <div><p><b>Servis:</b> <?php echo e($quotation->booking->service->name); ?></div>
                            <div class="ml-auto p-2"><p class="text-primary"></div>
                        </div>
                        <p>
                            Ini adalah jumlah bayaran yang perlu dibuat bagi memulakan proses kerja pembaikan agar dapat dijalankan. 
                            Sila pastikan untuk menyelesaikan bayaran ini bagi mengelakkan sebarang kelewatan dalam proses pembaikan rumah anda.
                        </p>
                        <div>
                            <input type="button" value="Teruskan ke Pembayaran" class="btn btn-warning btn-block" onclick="window.location.href='<?php echo e(route('payment.create', ['bookingId' => $quotation->booking->id, 'quotationId' => $quotation->id])); ?>';">
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-md-4 offset-md-1 mobile">
                    <div class="py-4 d-flex justify-content-end">
                        <h6><a href="<?php echo e(route('booking.progress', ['id' => $quotation->booking->id])); ?>">Kembali ke Jejak Tempahan</a></h6>
                    </div>
                    <div class="bg-light rounded d-flex flex-column">
                        <div class="p-2 ml-3">
                            <h4 class="text-center">Senarai Harga</h4>
                        </div>
                    
                        <?php if(!empty($items)): ?>
                            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="p-2 d-flex">
                                    <div class="col-8"><h6><?php echo e($item['scope_of_work']); ?></h6></div>
                                    <div class="ml-auto"><?php echo e($item['quantity']); ?> qty</div>
                                </div>
                                <div class="p-2 d-flex">
                                    <div class="col-8">Harga seunit</div>
                                    <div class="ml-auto">RM <?php echo e(number_format($item['unit_price'], 2)); ?></div>
                                </div>
                                <div class="p-2 d-flex">
                                    <div class="col-8">Jumlah</div>
                                    <div class="ml-auto">RM <?php echo e(number_format($item['total_price'], 2)); ?></div>
                                </div>
                                <div class="border-top px-4 mx-3"></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="p-2 text-center">
                                <p>Tiada item sebut harga tersedia.</p>
                            </div>
                        <?php endif; ?>
                    
                        <div class="p-2 d-flex pt-3">
                            <div class="col-8"><b>Total Keseluruhan</b></div>
                            <div class="ml-auto"><b class="green">RM <?php echo e(number_format($quotation->booking->total_payment, 2)); ?></b></div>
                        </div>
                    </div>
                    
                </div>        
            </div>
        </div>
    
    </section>

    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>

    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/payment/index.blade.php ENDPATH**/ ?>