<?php $__env->startSection('title', 'Profile'); ?>

<?php $__env->startSection('content'); ?>

<!-- Nucleo Icons -->
<link href="<?php echo e(asset('assets/css/nucleo-icons.css')); ?>" rel="stylesheet" />
<link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />
<!-- Font Awesome Icons -->
<script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
<link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />
<!-- CSS Files -->
<link id="pagestyle" href="<?php echo e(asset('assets/css/soft-ui-dashboard.css?v=1.0.3')); ?>" rel="stylesheet" />


<!-- Page Title -->
<div class="page-title" data-aos="fade" style="background-image: url('assets/img/page-title-bg.jpg')">
    <div class="container position-relative">
        <h1 class="text-white">Profil</h1>
        <nav class="breadcrumbs">
            <ol>
                <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                <li class="current">Profil</li>
            </ol>
        </nav>
    </div>
</div><!-- End Page Title -->

<!-- Starter Section Section -->
<section style="background: #f6f9ff;">

    <div class="container center-container">

        <div class="container-fluid my-3 py-3">
            <div class="row mb-5">
                <div class="col-lg-3">
                    <div class="card position-sticky top-1">
                        <ul class="nav flex-column bg-white border-radius-lg p-3">
                            <li class="nav-item">
                                <a class="nav-link text-body" data-scroll="" href="#profile">
                                    <div class="icon me-2">
                                        <svg class="text-dark mb-1" width="16px" height="16px" viewBox="0 0 40 40"
                                            version="1.1" xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink">
                                            <title>spaceship</title>
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <g transform="translate(-1720.000000, -592.000000)" fill="#FFFFFF"
                                                    fill-rule="nonzero">
                                                    <g transform="translate(1716.000000, 291.000000)">
                                                        <g transform="translate(4.000000, 301.000000)">
                                                            <path class="color-background"
                                                                d="M39.3,0.706666667 C38.9660984,0.370464027 38.5048767,0.192278529 38.0316667,0.216666667 C14.6516667,1.43666667 6.015,22.2633333 5.93166667,22.4733333 C5.68236407,23.0926189 5.82664679,23.8009159 6.29833333,24.2733333 L15.7266667,33.7016667 C16.2013871,34.1756798 16.9140329,34.3188658 17.535,34.065 C17.7433333,33.98 38.4583333,25.2466667 39.7816667,1.97666667 C39.8087196,1.50414529 39.6335979,1.04240574 39.3,0.706666667 Z M25.69,19.0233333 C24.7367525,19.9768687 23.3029475,20.2622391 22.0572426,19.7463614 C20.8115377,19.2304837 19.9992882,18.0149658 19.9992882,16.6666667 C19.9992882,15.3183676 20.8115377,14.1028496 22.0572426,13.5869719 C23.3029475,13.0710943 24.7367525,13.3564646 25.69,14.31 C26.9912731,15.6116662 26.9912731,17.7216672 25.69,19.0233333 L25.69,19.0233333 Z">
                                                            </path>
                                                            <path class="color-background"
                                                                d="M1.855,31.4066667 C3.05106558,30.2024182 4.79973884,29.7296005 6.43969145,30.1670277 C8.07964407,30.6044549 9.36054508,31.8853559 9.7979723,33.5253085 C10.2353995,35.1652612 9.76258177,36.9139344 8.55833333,38.11 C6.70666667,39.9616667 0,40 0,40 C0,40 0,33.2566667 1.855,31.4066667 Z">
                                                            </path>
                                                            <path class="color-background"
                                                                d="M17.2616667,3.90166667 C12.4943643,3.07192755 7.62174065,4.61673894 4.20333333,8.04166667 C3.31200265,8.94126033 2.53706177,9.94913142 1.89666667,11.0416667 C1.5109569,11.6966059 1.61721591,12.5295394 2.155,13.0666667 L5.47,16.3833333 C8.55036617,11.4946947 12.5559074,7.25476565 17.2616667,3.90166667 L17.2616667,3.90166667 Z"
                                                                opacity="0.598539807"></path>
                                                            <path class="color-background"
                                                                d="M36.0983333,22.7383333 C36.9280725,27.5056357 35.3832611,32.3782594 31.9583333,35.7966667 C31.0587397,36.6879974 30.0508686,37.4629382 28.9583333,38.1033333 C28.3033941,38.4890431 27.4704606,38.3827841 26.9333333,37.845 L23.6166667,34.53 C28.5053053,31.4496338 32.7452344,27.4440926 36.0983333,22.7383333 L36.0983333,22.7383333 Z"
                                                                opacity="0.598539807"></path>
                                                        </g>
                                                    </g>
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <span class="text-sm">Profil</span>
                                </a>
                            </li>
                            <li class="nav-item pt-2">
                                <a class="nav-link text-body" data-scroll="" href="#basic-info">
                                    <div class="icon me-2">
                                        <svg class="text-dark mb-1" width="16px" height="16px" viewBox="0 0 40 44"
                                            version="1.1" xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink">
                                            <title>document</title>
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <g transform="translate(-1870.000000, -591.000000)" fill="#FFFFFF"
                                                    fill-rule="nonzero">
                                                    <g transform="translate(1716.000000, 291.000000)">
                                                        <g transform="translate(154.000000, 300.000000)">
                                                            <path class="color-background"
                                                                d="M40,40 L36.3636364,40 L36.3636364,3.63636364 L5.45454545,3.63636364 L5.45454545,0 L38.1818182,0 C39.1854545,0 40,0.814545455 40,1.81818182 L40,40 Z"
                                                                opacity="0.603585379"></path>
                                                            <path class="color-background"
                                                                d="M30.9090909,7.27272727 L1.81818182,7.27272727 C0.814545455,7.27272727 0,8.08727273 0,9.09090909 L0,41.8181818 C0,42.8218182 0.814545455,43.6363636 1.81818182,43.6363636 L30.9090909,43.6363636 C31.9127273,43.6363636 32.7272727,42.8218182 32.7272727,41.8181818 L32.7272727,9.09090909 C32.7272727,8.08727273 31.9127273,7.27272727 30.9090909,7.27272727 Z M18.1818182,34.5454545 L7.27272727,34.5454545 L7.27272727,30.9090909 L18.1818182,30.9090909 L18.1818182,34.5454545 Z M25.4545455,27.2727273 L7.27272727,27.2727273 L7.27272727,23.6363636 L25.4545455,23.6363636 L25.4545455,27.2727273 Z M25.4545455,20 L7.27272727,20 L7.27272727,16.3636364 L25.4545455,16.3636364 L25.4545455,20 Z">
                                                            </path>
                                                        </g>
                                                    </g>
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <span class="text-sm">Maklumat Peribadi</span>
                                </a>
                            </li>
                            <li class="nav-item pt-2">
                                <a class="nav-link text-body" data-scroll="" href="#password">
                                    <div class="icon me-2">
                                        <svg class="text-dark mb-1" width="16px" height="16px" viewBox="0 0 42 42"
                                            version="1.1" xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink">
                                            <title>box-3d-50</title>
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <g transform="translate(-2319.000000, -291.000000)" fill="#FFFFFF"
                                                    fill-rule="nonzero">
                                                    <g transform="translate(1716.000000, 291.000000)">
                                                        <g transform="translate(603.000000, 0.000000)">
                                                            <path class="color-background"
                                                                d="M22.7597136,19.3090182 L38.8987031,11.2395234 C39.3926816,10.9925342 39.592906,10.3918611 39.3459167,9.89788265 C39.249157,9.70436312 39.0922432,9.5474453 38.8987261,9.45068056 L20.2741875,0.1378125 L20.2741875,0.1378125 C19.905375,-0.04725 19.469625,-0.04725 19.0995,0.1378125 L3.1011696,8.13815822 C2.60720568,8.38517662 2.40701679,8.98586148 2.6540352,9.4798254 C2.75080129,9.67332903 2.90771305,9.83023153 3.10122239,9.9269862 L21.8652864,19.3090182 C22.1468139,19.4497819 22.4781861,19.4497819 22.7597136,19.3090182 Z">
                                                            </path>
                                                            <path class="color-background"
                                                                d="M23.625,22.429159 L23.625,39.8805372 C23.625,40.4328219 24.0727153,40.8805372 24.625,40.8805372 C24.7802551,40.8805372 24.9333778,40.8443874 25.0722402,40.7749511 L41.2741875,32.673375 L41.2741875,32.673375 C41.719125,32.4515625 42,31.9974375 42,31.5 L42,14.241659 C42,13.6893742 41.5522847,13.241659 41,13.241659 C40.8447549,13.241659 40.6916418,13.2778041 40.5527864,13.3472318 L24.1777864,21.5347318 C23.8390024,21.7041238 23.625,22.0503869 23.625,22.429159 Z"
                                                                opacity="0.7"></path>
                                                            <path class="color-background"
                                                                d="M20.4472136,21.5347318 L1.4472136,12.0347318 C0.953235098,11.7877425 0.352562058,11.9879669 0.105572809,12.4819454 C0.0361450918,12.6208008 6.47121774e-16,12.7739139 0,12.929159 L0,30.1875 L0,30.1875 C0,30.6849375 0.280875,31.1390625 0.7258125,31.3621875 L19.5528096,40.7750766 C20.0467945,41.0220531 20.6474623,40.8218132 20.8944388,40.3278283 C20.963859,40.1889789 21,40.0358742 21,39.8806379 L21,22.429159 C21,22.0503869 20.7859976,21.7041238 20.4472136,21.5347318 Z"
                                                                opacity="0.7"></path>
                                                        </g>
                                                    </g>
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <span class="text-sm">Tukar Kata Laluan</span>
                                </a>
                            </li>
                            <li class="nav-item pt-2">
                                <a class="nav-link text-body" data-scroll="" href="#delete">
                                    <div class="icon me-2">
                                        <svg class="text-dark mb-1" width="16px" height="16px"
                                            viewBox="0 0 45 40" version="1.1" xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink">
                                            <title>shop </title>
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <g transform="translate(-1716.000000, -439.000000)" fill="#FFFFFF"
                                                    fill-rule="nonzero">
                                                    <g transform="translate(1716.000000, 291.000000)">
                                                        <g transform="translate(0.000000, 148.000000)">
                                                            <path class="color-background"
                                                                d="M46.7199583,10.7414583 L40.8449583,0.949791667 C40.4909749,0.360605034 39.8540131,0 39.1666667,0 L7.83333333,0 C7.1459869,0 6.50902508,0.360605034 6.15504167,0.949791667 L0.280041667,10.7414583 C0.0969176761,11.0460037 -1.23209662e-05,11.3946378 -1.23209662e-05,11.75 C-0.00758042603,16.0663731 3.48367543,19.5725301 7.80004167,19.5833333 L7.81570833,19.5833333 C9.75003686,19.5882688 11.6168794,18.8726691 13.0522917,17.5760417 C16.0171492,20.2556967 20.5292675,20.2556967 23.494125,17.5760417 C26.4604562,20.2616016 30.9794188,20.2616016 33.94575,17.5760417 C36.2421905,19.6477597 39.5441143,20.1708521 42.3684437,18.9103691 C45.1927731,17.649886 47.0084685,14.8428276 47.0000295,11.75 C47.0000295,11.3946378 46.9030823,11.0460037 46.7199583,10.7414583 Z"
                                                                opacity="0.598981585"></path>
                                                            <path class="color-foreground"
                                                                d="M39.198,22.4912623 C37.3776246,22.4928106 35.5817531,22.0149171 33.951625,21.0951667 L33.92225,21.1107282 C31.1430221,22.6838032 27.9255001,22.9318916 24.9844167,21.7998837 C24.4750389,21.605469 23.9777983,21.3722567 23.4960833,21.1018359 L23.4745417,21.1129513 C20.6961809,22.6871153 17.4786145,22.9344611 14.5386667,21.7998837 C14.029926,21.6054643 13.533337,21.3722507 13.0522917,21.1018359 C11.4250962,22.0190609 9.63246555,22.4947009 7.81570833,22.4912623 C7.16510551,22.4842162 6.51607673,22.4173045 5.875,22.2911849 L5.875,44.7220845 C5.875,45.9498589 6.7517757,46.9451667 7.83333333,46.9451667 L19.5833333,46.9451667 L19.5833333,33.6066734 L27.4166667,33.6066734 L27.4166667,46.9451667 L39.1666667,46.9451667 C40.2482243,46.9451667 41.125,45.9498589 41.125,44.7220845 L41.125,22.2822926 C40.4887822,22.4116582 39.8442868,22.4815492 39.198,22.4912623 Z">
                                                            </path>
                                                        </g>
                                                    </g>
                                                </g>
                                            </g>
                                        </svg>
                                    </div>
                                    <span class="text-sm">Padam Akaun</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-9 mt-lg-0 mt-4">
                    <!-- Card: Profile Picture -->
                    <div class="card card-body mb-4 mt-2" id="profile">
                        <form action="<?php echo e(route('profile.updateProfileImage')); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row justify-content-center align-items-center">
                                <div class="col-sm-auto col-.4 text-center">
                                    <div class="avatar avatar-xxl position-relative"
                                        style="width: 150px; height: 150px;">
                                        <label for="profile_image" style="cursor: pointer; display: block;">
                                            <img id="profileImagePreview"
                                                src="<?php echo e($user->profile_image ? asset('uploads/profile_images/' . $user->profile_image) : asset('assets/img/profile.png')); ?>"
                                                alt="Profile Image" class="rounded-circle shadow-sm w-100 h- mt-5"
                                                style="object-fit: cover;">
                                            <input type="file" id="profile_image" name="profile_image"
                                                class="d-none" onchange="previewProfileImage(event)">
                                        </label>
                                    </div>
                                </div>
                                <div class="col-sm-auto col-8 my-auto">
                                    <div class="h-100">
                                        <h5 class="mb-1 font-weight-bolder">
                                            <?php echo e(old('name', $user->name)); ?>

                                        </h5>
                                        <p class="text-sm mt-2">Klik pada imej untuk kemas kini</p>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn bg-gradient-dark float-end mt-4">Kemaskini Imej</button>
                        </form>
                    </div>

                    <!-- Card: Basic Info -->
                    <div class="card mt-4" id="basic-info">
                        <div class="card-header">
                            <h5>Maklumat Peribadi</h5>
                        </div>
                        <div class="card-body pt-0">
                            <form action="<?php echo e(route('profile.updateInfo')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-12">
                                        <label class="form-label">Nama</label>
                                        <div class="input-group">
                                            <input id="name" name="name" class="form-control" type="text"
                                                value="<?php echo e(old('name', $user->name)); ?>" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <label class="form-label mt-4">Emel</label>
                                        <div class="input-group">
                                            <input id="email" name="email" class="form-control"
                                                value="<?php echo e(old('email', $user->email)); ?>" type="email">
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <label class="form-label mt-4">No. Telefon Bimbit</label>
                                        <div class="input-group">
                                            <input id="phoneNum" name="phoneNum" class="form-control"
                                                value="<?php echo e(old('phoneNum', $user->phoneNum)); ?>" type="number">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6 col-6">
                                        <label class="form-label mt-4">Jantina</label>
                                        <select class="form-control" name="gender" id="gender">
                                            <option value="" <?php echo e($user->gender == null ? 'selected' : ''); ?>>Pilih
                                                Jantina</option>
                                            <option value="Lelaki" <?php echo e($user->gender == 'Lelaki' ? 'selected' : ''); ?>>
                                                Lelaki</option>
                                            <option value="Perempuan"
                                                <?php echo e($user->gender == 'Perempuan' ? 'selected' : ''); ?>>Perempuan</option>
                                            <option value="Lain-lain"
                                                <?php echo e($user->gender == 'Lain-lain' ? 'selected' : ''); ?>>Lain-lain</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-6">
                                        <label class="form-label mt-4">Tarikh Lahir</label>
                                        <div class="input-group">
                                            <input type="date" id="dob" name="dob"
                                                value="<?php echo e(old('dob', \Carbon\Carbon::parse($user->dob)->format('Y-m-d') ?? '')); ?>"
                                                class="form-control" max="<?php echo e(now()->format('Y-m-d')); ?>">
                                        </div>
                                    </div>

                                </div>
                                <button class="btn bg-gradient-dark float-end mt-4">Kemaskini Maklumat</button>
                            </form>
                        </div>
                    </div>

                    <!-- Card: Change Password -->
                    <div class="card mt-4" id="password">
                        <div class="card-header">
                            <h5>Tukar Kata Laluan</h5>
                        </div>
                        <div class="card-body pt-0">
                            

                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger" role="alert"
                            style="all: unset; display: block; background-color: #f8d7da; color: #721c24; padding: 1rem; border: 1px solid #f5c6cb; border-radius: 0.25rem;">
                            <ul style="margin: 0; padding-left: 1.25rem;">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route('profile.changePassword')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <label>Kata Laluan Semasa</label>
                            <div class="form-group">
                                <input class="form-control" type="password" id="current_password"
                                    name="current_password" required>
                            </div>
                            <label>Kata Laluan Baharu</label>
                            <div class="form-group">
                                <input class="form-control" type="password" id="new_password"
                                    name="new_password" required>
                            </div>
                            <label>Sahkan Kata Laluan Baharu</label>
                            <div class="form-group">
                                <input class="form-control" type="password" id="new_password_confirmation"
                                    name="new_password_confirmation" required>
                            </div>
                            <h5 class="mt-4">Keperluan Kata Laluan</h5>
                            <ul class="text-muted ps-4 mb-0">
                                <li><span class="text-sm">Satu aksara khas</span></li>
                                <li><span class="text-sm">Sekurang-kurangnya 6 aksara</span></li>
                                <li><span class="text-sm">Satu nombor (2 nombor adalah disyorkan)</span></li>
                            </ul>
                            <button class="btn bg-gradient-dark float-end mt-4">Kemaskini Kata Laluan</button>
                        </form>
                    </div>
                </div>

                <!-- Card: Delete Account -->
                <div class="card mt-4" id="delete">
                    <div class="card-header">
                        <h5>Padam Akaun</h5>
                        <p class="text-sm mb-0">Sila pastikan keputusan anda. Akaun yang dipadam tidak boleh
                            dipulihkan.</p>
                    </div>
                    <div class="card-body d-sm-flex pt-0">
                        <button class="btn bg-gradient-danger mb-0" type="button"
                            onclick="soft.showSwal('warning-message-and-confirmation', <?php echo e(Auth::user()->id); ?>)">
                            Padam Akaun
                        </button>
                    </div>
                </div>

            </div>

        </div>
    </div>

</section>

<!--   Core JS Files   -->
<script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/perfect-scrollbar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/datatables.js')); ?>"></script>

<!-- Kanban scripts -->
<script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/multistep-form.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/choices.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/sweetalert.min.js')); ?>"></script>

<script>
    function previewProfileImage(event) {
        const reader = new FileReader();
        reader.onload = function() {
            const preview = document.getElementById('profileImagePreview');
            preview.src = reader.result;
        };
        reader.readAsDataURL(event.target.files[0]);
    }
</script>


<script>
    const soft = {
        showSwal: function(type, userId) {
            if (type === 'warning-message-and-confirmation') {
                Swal.fire({
                    title: 'Adakah anda pasti?',
                    text: "Akaun anda akan dipadam dan tidak dapat dipulihkan!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Ya, padam!',
                    cancelButtonText: 'Batal',
                    buttonsStyling: false,
                    customClass: {
                        confirmButton: 'btn btn-danger m-3',
                        cancelButton: 'btn btn-secondary m-3'
                    }
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Create a form to submit the delete request
                        const form = document.createElement('form');
                        form.method = 'POST';
                        form.action = `/profil/padam-akaun`; // Route for account deletion

                        // Add CSRF token
                        const csrfToken = document.querySelector('meta[name="csrf-token"]')
                            .getAttribute('content');
                        const csrfInput = document.createElement('input');
                        csrfInput.type = 'hidden';
                        csrfInput.name = '_token';
                        csrfInput.value = csrfToken;
                        form.appendChild(csrfInput);

                        // Add method override for DELETE
                        const methodInput = document.createElement('input');
                        methodInput.type = 'hidden';
                        methodInput.name = '_method';
                        methodInput.value = 'DELETE';
                        form.appendChild(methodInput);

                        // Append form to body and submit
                        document.body.appendChild(form);
                        form.submit();
                    }
                });
            }
        }
    };
</script>

<script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
        var options = {
            damping: '0.5'
        }
        Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
</script>

<!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
<script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/profile.blade.php ENDPATH**/ ?>