<?php $__env->startSection('title', 'Pengesahan Pembayaran'); ?>

<?php $__env->startSection('content'); ?>

<style>

    @media(max-width: 567px) {
        .mobile {
            padding-top: 40px;
        }
    }
</style>


<!-- Page Title -->
<div class="page-title" data-aos="fade" style="background-image: url(<?php echo e(asset('assets/img/page-title-bg.jpg')); ?>);">
    <div class="container position-relative">
        <h1 class="text-white">Pengesahan Pembayaran</h1>
        <nav class="breadcrumbs">
            <ol>
                <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                <li><a href="<?php echo e(route('booking.index')); ?>" style="color: #feb900">Servis > Senarai Tempahan</a></li>
                <li class="current">Pengesahan Pembayaran</li>
            </ol>
        </nav>
    </div>
</div><!-- End Page Title -->

<section style="background: #f6f9ff;">

    <!-- Success Alert -->
    <!-- <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?> -->

    <!-- Error Alert -->
    <!-- <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?> -->

    <div class="container center-container">
        <div class="mb-3" style="background: #fff; padding: 40px 30px; border-radius: 12px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); text-align: center; max-width: 500px; margin: 0 auto;">
            <div class="bg-light">
                <h3 class="sitename mb-3">MyTukang<span style="color: #feb900">.</span></h3>
            </div>
            <?php if($payment->status === 'successful'): ?>
            <h1 class="text-success mx-2" style="font-size: 2.5rem; "><?php echo e($payment->booking->status); ?>!</h1>
            <?php elseif($payment->status === 'failed'): ?>
            <h1 class="text-danger mx-2" style="font-size: 2.5rem; "><?php echo e($payment->booking->status); ?>!</h1>
            <?php else: ?>
            <h1 class="text-warning mx-2" style="font-size: 2.5rem; "><?php echo e($payment->booking->status); ?>!</h1>
            <?php endif; ?>
            <p style="font-size: 1rem; line-height: 1.6; color: #555;">Pembayaran tempahan anda untuk perkhidmatan pembaikan rumah  
                <?php if($payment->status === 'succesful'): ?>
                telah berjaya
                <?php elseif($payment->status === 'failed'): ?>
                tidak berjaya. Sila lakukan pembayaran semula
                <?php else: ?>
                belum selesai. Sila lakukan pembayaran dengan segera
                .</p>
                <?php endif; ?>
            <div style="margin: 20px 0; background: #f9f9f9; padding: 15px; border-radius: 8px; border: 1px solid #ddd; text-align: left; font-size: 0.95rem;">
                <p style="margin-bottom: 10px;"><strong>ID Tempahan:</strong> <?php echo e($payment->booking->id); ?></p>
                <p style="margin-bottom: 10px;"><strong>Kod Bil:</strong> #<?php echo e($payment->bill_code); ?></p>
                <p style="margin-bottom: 10px;"><strong>Tarikh Perkhidmatan:</strong> <?php echo e($payment->booking->approved_date->format('d/m/Y')); ?></p>
                <p style="margin-bottom: 10px;"><strong>Masa Perkhidmatan:</strong> <?php echo e($payment->booking->approved_time->format('H:i')); ?></p>
                <p style="margin-bottom: 10px;"><strong>Nama Servis:</strong> <?php echo e($payment->booking->subService->name); ?></p>
            </div>
            <p style="font-size: 1rem; line-height: 1.6; color: #555;">Anda akan menerima emel dengan semua butiran tidak lama lagi. Kami menantikan peluang untuk berkhidmat kepada anda!</p>
            <?php if($payment->status === 'pending' || $payment->status === 'failed'): ?>
            <a class="bg-secondary" href="<?php echo e(route('payment.create', ['bookingId' => $payment->booking->id, 'quotationId' => $payment->booking->quotation->id])); ?>" style="display: inline-block; margin-top: 20px; padding: 10px 20px;  color: #fff; text-decoration: none; font-weight: 500; border-radius: 5px; transition: background 0.3s;">Membuat Pembayaran Semula</a>
            <?php else: ?>
            <a class="bg-secondary" href="<?php echo e(route('booking.progress', ['id' => $payment->booking->id])); ?>" style="display: inline-block; margin-top: 20px; padding: 10px 20px;  color: #fff; text-decoration: none; font-weight: 500; border-radius: 5px; transition: background 0.3s;">Kembali ke Laman Utama</a>
            <?php endif; ?>
        </div>
    </div>

</section>

<script>
    var win = navigator.platform.indexOf('Win') > -1;
    if (win && document.querySelector('#sidenav-scrollbar')) {
        var options = {
            damping: '0.5'
        }
        Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
    }
</script>

<!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
<script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/payment/show.blade.php ENDPATH**/ ?>