<?php $__env->startSection('title', 'Sebut Harga'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Page Title -->
    <div class="page-title" data-aos="fade" style="background-image: url(<?php echo e(asset('assets/img/page-title-bg.jpg')); ?>);">
        <div class="container position-relative">
            <h1 class="text-white">Sebut Harga</h1>
            <nav class="breadcrumbs">
                <ol>
                    <li><a href="/" style="color: #feb900">Laman Utama</a></li>
                    <li><a href="<?php echo e(route('booking.index')); ?>" style="color: #feb900">Servis > Senarai Tempahan</a></li>
                    <li class="current">Papar Sebut Harga</li>
                </ol>
            </nav>
        </div>
    </div><!-- End Page Title -->

    <!-- Section -->
    <section style="background: #f6f9ff;">

        <div class="container-fluid py-4" style="width: 70%">

            <div class="row">
                <div class="col-12">
                    <div class="card p-4">
                        <div class="card-body">

                            <!-- Quotation Detail-->
                            <div class="row mt-4">
                                <div class="col-8">
                                    
                                    <address>
                                        <b>Yusof Abdullah</b> <br>
                                        64, Lebuh Pendamar Indah 1<br>
                                        Taman Pendamar Indah<br>
                                        42000 Pelabuhan Klang, Selangor<br>
                                        <abbr title="Phone">Tel No:</abbr> (+60) 10-5235987
                                    </address>
                                </div>

                                <div class="col-4 mt-4">
                                    <h3 class="sitename">MyTukang<span style="color: #feb900">.</span></h3>
                                </div>
                            </div>

                            <!-- Horizontal line -->
                            <hr>

                            <!-- end row -->

                            <div class="row mt-4">
                                <div class="col-sm-8">
                                    <p><b>Kepada:</b></p>
                                        <p>
                                            <?php echo e($quotation->booking->user->name); ?><br>
                                            <?php echo e($quotation->booking->address->address_line1); ?><br>
                                            <?php echo e($quotation->booking->address->address_line2); ?><br>
                                            <?php echo e($quotation->booking->address->postcode); ?> <?php echo e($quotation->booking->address->city); ?>

                                        </p>
                                </div> <!-- end col-->

                                <div class="col-sm-4">
                                    <div class="float-sm-right">
                                        <p style="color: black; font-size:14px;"><b>Tarikh Sebut Harga:</b></p>
                                        <p><?php echo e($quotation->created_at->format('d/m/Y')); ?></p>
                                    
                                        <p style="color: black; font-size:14px;"><b>No. Tempahan:</b></p>
                                        <p>#<?php echo e($quotation->booking->id); ?></p>
                                    </div>
                                </div> <!-- end col-->

                            </div>
                            <!-- end row -->

                            <!-- Quotation Items -->
                            <div class="row">
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th scope="col" class="pe-2 text-start ps-2">#</th>
                                                    <th scope="col" class="pe-2">Skop kerja</th>
                                                    <th scope="col" class="pe-2">Kuantiti</th>
                                                    <th scope="col" class="pe-2">Harga seunit</th>
                                                    <th scope="col" class="pe-2">Jumlah</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(!empty($items)): ?>
                                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($index + 1); ?></td>
                                                            <td><?php echo e($item['scope_of_work']); ?></td>
                                                            <td><?php echo e($item['quantity']); ?></td>
                                                            <td>RM <?php echo e(number_format($item['unit_price'], 2)); ?></td>
                                                            <td>RM <?php echo e(number_format($item['total_price'], 2)); ?></td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <tr>
                                                        <td colspan="5" class="text-center">Tiada item sebut harga tersedia.</td>
                                                    </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div><!-- end table-responsive-->
                                </div> <!-- end col -->
                            </div>
                            <!-- end row -->

                            <!-- Total Amount -->
                            <div class="row">
                                <div class="col-8 text-end">
                                    <p><b>Jumlah Keseluruhan</b></p>
                                </div>
                                <div class="col-4 text-center">
                                    <p><b>RM <?php echo e(number_format($quotation->booking->total_payment, 2)); ?></b></p>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-8">
                                    <div class="clearfix pt-3">
                                        <h6 class="text-muted">Nota:</h6>
                                        <small>
                                            <i>Jumlah bayaran termasuk harga barang (jika ada) dan upah pemasagan/baik pulih.</i>
                                            
                                        </small>
                                    </div>
                                </div> <!-- end col -->
                            </div>
                            <!-- end row-->

                            <div class="row">
                                <div class="button-row d-flex mt-4 col-12">

                                    <?php if($quotation->booking->status === 'Sebut Harga' || $quotation->booking->status === 'Sebut Harga Baru'): ?>
                                        <button type="button" class="btn btn-danger mb-0 js-btn-next text-white" data-bs-toggle="modal" data-bs-target="#rejectModal" style="margin-right: auto;">
                                            Tolak
                                        </button>
                                        <button type="submit" class="btn btn-warning mb-0 js-btn-next text-white" onclick="window.location.href='<?php echo e(route('quotation.accept', $quotation->id)); ?>'">
                                            Terima
                                        </button>
                                    <?php else: ?>
                                        <button type="button" class="btn btn-secondary mb-0 js-btn-next text-white" onclick="history.back()" style="margin-right: auto;">
                                            Kembali
                                        </button>
                                    <?php endif; ?>


                                </div>

                            </div>

                            <!-- end buttons -->

                            <!-- Modal -->
                            <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="rejectModalLabel">Tolak Sebut Harga</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <form method="POST" action="<?php echo e(route('quotation.reject', $quotation->id)); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-body">
                                                <div class="row">
                                                    <div class="col">
                                                        <div class="form-group">
                                                            <label for="reason" class="form-label">Sebab Penolakan</label>
                                                            <select class="form-control" name="reason" id="reason" required>
                                                                <option value="">Pilih Sebab</option>
                                                                <option value="Harga Terlalu Mahal">Harga Terlalu Mahal</option>
                                                                <option value="Tidak Memerlukan Servis Lagi">Tidak Memerlukan Servis Lagi</option>
                                                                <option value="Sebut Harga Tidak Mengikut Keperluan">Sebut Harga Tidak Mengikut Keperluan</option>   
                                                                <option value="Lain-lain">Lain-Lain</option>   
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Lain-Lain reason text area -->
                                                <div class="row mt-3" id="otherReasonContainer" style="display: none;">
                                                    <div class="col">
                                                        <div class="form-group">
                                                            <label for="otherReason" class="form-label">Sebab Lain</label>
                                                            <textarea class="form-control" name="otherReason" id="otherReason" rows="3" placeholder="Nyatakan sebab lain di sini..."></textarea>
                                                        </div>
                                                    </div>
                                                </div>

                                                <?php if($quotation->booking->status == 'Sebut Harga'): ?>
                                                <!-- Checkbox for new quotation -->
                                                <div class="row mt-3">
                                                    <div class="col">
                                                        <div class="form-group">
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="checkbox" name="newQuotation" id="newQuotation" value="1">
                                                                <label class="form-check-label" for="newQuotation">Adakah anda ingin menerima sebut harga baharu?</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                                <button type="submit" class="btn btn-warning text-black">Hantar</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>


                        </div> <!-- end card-body-->
                    </div> <!-- end card -->
                </div> <!-- end col-->
            </div>
            <!-- end row -->

        </div>

    </section>


    <!--   Core JS Files   -->
    <script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/datatables.js')); ?>"></script>

    <!-- Kanban scripts -->
    <script src="<?php echo e(asset('assets/js/plugins/dragula/dragula.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/jkanban/jkanban.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/multistep-form.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/choices.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/sweetalert.min.js')); ?>"></script>


    <script>
        var win = navigator.platform.indexOf('Win') > -1;
        if (win && document.querySelector('#sidenav-scrollbar')) {
            var options = {
                damping: '0.5'
            }
            Scrollbar.init(document.querySelector('#sidenav-scrollbar'), options);
        }
    </script>

    <!-- Add new input tag -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const reasonDropdown = document.getElementById('reason'); // Dropdown
            const otherReasonContainer = document.getElementById('otherReasonContainer'); // Textarea container

            // Add event listener to the dropdown
            reasonDropdown.addEventListener('change', function () {
                if (this.value === 'Lain-lain') {
                    otherReasonContainer.style.display = 'block'; // Show textarea
                } else {
                    otherReasonContainer.style.display = 'none'; // Hide textarea
                }
            });
        });
    </script>

    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="<?php echo e(asset('assets/js/soft-ui-dashboard.min.js?v=1.0.3')); ?>"></script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\fatin\Downloads\Degree UMPSA\MyTukang\resources\views/quotation/show.blade.php ENDPATH**/ ?>