<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;
    protected $fillable = ['name'];

    public function plantDetails()
    {
        return $this->hasMany(PlantDetail::class);
    }

    public function farm()
    {
        return $this->hasMany(Farm::class);
    }

    public function fertilizerDetails()
    {
        return $this->hasMany(FertilizerDetail::class);
    }

    public function pestControlDetails()
    {
        return $this->hasMany(PestControlDetail::class);
    }
}
