@extends('layouts.base')

@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pengurusan</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('farm.index') }}">Kebun</a></li>
                        <li class="breadcrumb-item active">Papar Kebun</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Kebun</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Papar Kebun</h4>
                    <form>
                        <div class="form-row">
                            <div class="form-group col-md-8">
                                <label for="inputEmail4" class="col-form-label">Nama Kebun</label>
                                <input type="label" name="name" class="form-control" value="{{ $farm->name }}"
                                    readonly>
                            </div>
                            <div class="form-group col-md-4 ">
                                <label for="inputEmail4" class="col-form-label">Saiz Kebun</label>
                                <input type="number" name="size" class="form-control" value="{{ $farm->size }}"
                                    readonly>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Kategori Kebun</label>
                                <input type="text" name="category" class="form-control" value="{{ $farm->category->name }}"
                                    readonly>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="inputState" class="col-form-label">Jenis Kebun</label>
                                <input type="text" name="type" class="form-control" value="{{ $farm->type }}"
                                    readonly>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="example-textarea">Alamat Kebun</label>
                            <textarea class="form-control" name="address" id="example-textarea" rows="5" readonly>{{ $farm->address }}</textarea>

                        </div>
                        <div class="form-group ">
                            <label for="pdf">Dokumen PDF</label>
                            <p class="form-control-plaintext">
                                <a href="{{ Storage::url($farm->pdf) }}" target="_blank">Lihat PDF</a>
                            </p>

                        </div>
                        <div class="text-center mt-2">
                            <button type="button" onclick="history.back()" class="btn btn-info  ">Kembali</button>
                        </div>


                    </form>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>
    <!-- end row-->
@endsection
