
    <header>
        <h4 class="text-lg font-medium text-gray-900">
            <?php echo e(__('Maklumat Profil')); ?>

        </h4>

        <p class="mt-1 text-sm text-gray-600">
            <?php echo e(__('Kemaskini maklumat profil dan alamat e-mel akaun anda.')); ?>

        </p>
    </header>

    <form id="send-verification" method="post" action="<?php echo e(route('verification.send')); ?>">
        <?php echo csrf_field(); ?>
    </form>

   <form method="post" action="<?php echo e(route('profile.update')); ?>" class="mt-6 space-y-6">
    <?php echo csrf_field(); ?>
    <?php echo method_field('patch'); ?>

    <!-- Name Field -->
    <div class="form-row">
        <div class="form-group col-md-12">
            <label for="name" class="form-label"><?php echo e(__('Nama')); ?></label>
            <input id="name" name="name" type="text" class="form-control"
                value="<?php echo e(old('name', $user->name)); ?>" required autofocus autocomplete="name" />
            <?php if($errors->has('name')): ?>
                <div class="text-danger mt-2">
                    <?php echo e($errors->first('name')); ?>

                </div>
            <?php endif; ?>
        </div>

        <!-- Email Field -->
        <div class="form-group col-md-6">
            <label for="email" class="form-label"><?php echo e(__('Emel')); ?></label>
            <input id="email" name="email" type="email" class="form-control"
                value="<?php echo e(old('email', $user->email)); ?>" required autocomplete="username" />
            <?php if($errors->has('email')): ?>
                <div class="text-danger mt-2">
                    <?php echo e($errors->first('email')); ?>

                </div>
            <?php endif; ?>

            <!-- Email Verification Notice -->
            <?php if($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && !$user->hasVerifiedEmail()): ?>
                <div class="mt-2">
                    <p class="text-sm text-gray-800">
                        <?php echo e(__('Your email address is unverified.')); ?>


                        <button form="send-verification"
                            class="btn btn-link p-0 text-sm text-gray-600 hover:text-gray-900">
                            <?php echo e(__('Click here to re-send the verification email.')); ?>

                        </button>
                    </p>

                    <?php if(session('status') === 'verification-link-sent'): ?>
                        <p class="mt-2 text-sm text-success">
                            <?php echo e(__('A new verification link has been sent to your email address.')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

         <!-- Phone Field -->
         <div class="form-group col-md-6">
            <label for="phone" class="form-label"><?php echo e(__('Telefon')); ?></label>
            <input id="phone" name="phone" type="text" class="form-control"
                value="<?php echo e(old('phone', $user->phone)); ?>" autocomplete="phone" />
            <?php if($errors->has('phone')): ?>
                <div class="text-danger mt-2">
                    <?php echo e($errors->first('phone')); ?>

                </div>
            <?php endif; ?>
        </div>
         <!-- Role Field (Readonly) -->
         <div class="form-group col-md-6">
            <label for="role" class="form-label"><?php echo e(__('Peranan')); ?></label>
            <input id="role" name="role" type="text" class="form-control"
                value="<?php echo e($user->role); ?>" readonly />
        </div>

        <!-- Job Type Field (Readonly) -->
        <?php if($user->job_type): ?>
            <div class="form-group col-md-6">
                <label for="job_type" class="form-label"><?php echo e(__('Jenis Kerja')); ?></label>
                <input id="job_type" name="job_type" type="text" class="form-control"
                    value="<?php echo e($user->job_type); ?>" readonly />
            </div>
        <?php endif; ?>

        <!-- Address Field -->
        <div class="form-group col-md-12">
            <label for="address" class="form-label"><?php echo e(__('Alamat')); ?></label>
            <textarea class="form-control" name="address" id="example-textarea" rows="5"><?php echo e(old('address', $user->address)); ?></textarea>
            <?php if($errors->has('address')): ?>
                <div class="text-danger mt-2">
                    <?php echo e($errors->first('address')); ?>

                </div>
            <?php endif; ?>
        </div>

       
        <!-- Save Button -->
        <div class="form-group col-md-12">
            <button type="submit" class="btn btn-primary"><?php echo e(__('Simpan')); ?></button>
            <?php if(session('status') === 'profile-updated'): ?>
                <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-gray-600"><?php echo e(__('Saved.')); ?></p>
            <?php endif; ?>
        </div>
    </div>
</form>

<?php /**PATH C:\laragon\www\desa-grow-farm\resources\views/profile/partials/update-profile-information-form.blade.php ENDPATH**/ ?>