@extends('layouts.base')
@section('content')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Pengurusan</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('fertilizer-detail.index') }}">Baja</a></li>
                        <li class="breadcrumb-item active">Tambah Baja</li>
                    </ol>
                </div>
                <h4 class="page-title">Pengurusan Baja</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <h4 class="card-header bg-primary text-white">== Sila Isi Maklumat Dibawah ==</h4>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form role="form" method="POST" action="{{ route('fertilizer-detail.store') }}"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row mb-3">
                            <label class="col-md-3 col-form-label" for="userName">Kategori Pokok</label>
                            <div class="col-md-9">
                                <select id="plant_category" name="plant_category" class="form-control">
                                    <option value="">Sila Pilih</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div id="basicwizard">
                            <ul class="nav nav-pills nav-justified form-wizard-header mb-4">
                                <li class="nav-item">
                                    <a href="#basictab1" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
                                        <i class="mdi mdi-account-circle mr-1"></i>
                                        <span class="d-none d-sm-inline">Tumbesaran</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#basictab2" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
                                        <i class="mdi mdi-face-profile mr-1"></i>
                                        <span class="d-none d-sm-inline">Akar Pokok</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#basictab3" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
                                        <i class="mdi mdi-checkbox-marked-circle-outline mr-1"></i>
                                        <span class="d-none d-sm-inline">Buah</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#basictab4" data-toggle="tab" class="nav-link rounded-0 pt-2 pb-2">
                                        <i class="mdi mdi-checkbox-marked-circle-outline mr-1"></i>
                                        <span class="d-none d-sm-inline">Matang</span>
                                    </a>
                                </li>
                            </ul>

                            <div class="tab-content b-0 mb-0">
                                <div class="tab-pane" id="basictab1">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="userName">Kegunaan Baja</label>
                                                <div class="col-md-9">
                                                    <select name="fertilizer_type[]" id="fertilizer_type"
                                                        class="form-control">
                                                        <option>Sila Pilih</option>
                                                        <option value="Tumbesaran">Tumbesaran</option>
                                                        <option value="Akar Pokok">Akar Pokok</option>
                                                        <option value="Buah">Buah</option>
                                                        <option value="Matang">Matang</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="namabaja"> Nama Baja</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="fertilizer_name[]" class="form-control"
                                                        id="inputNamaBaja" placeholder="Eg: Urea">
                                                </div>
                                            </div>

                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="confirm">Muat Naik
                                                    Gambar</label>
                                                <div class="col-md-9">
                                                    <input type="file" name="image[]" class="form-control" id="image"
                                                        accept="image/*">
                                                </div>
                                            </div>
                                        </div> <!-- end col -->
                                    </div> <!-- end row -->
                                </div>

                                <div class="tab-pane" id="basictab2">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="userName">Kegunaan Baja</label>
                                                <div class="col-md-9">
                                                    <select name="fertilizer_type[]" id="fertilizer_type"
                                                        class="form-control">
                                                        <option>Sila Pilih</option>
                                                        <option value="Tumbesaran">Tumbesaran</option>
                                                        <option value="Akar Pokok">Akar Pokok</option>
                                                        <option value="Buah">Buah</option>
                                                        <option value="Matang">Matang</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="namabaja"> Nama Baja</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="fertilizer_name[]" class="form-control"
                                                        id="inputNamaBaja" placeholder="Eg: Urea">
                                                </div>
                                            </div>

                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="confirm">Muat Naik
                                                    Gambar</label>
                                                <div class="col-md-9">
                                                    <input type="file" name="image[]" class="form-control"
                                                        id="image" accept="image/*">
                                                </div>
                                            </div>
                                        </div> <!-- end col -->
                                    </div> <!-- end row -->
                                </div>

                                <div class="tab-pane" id="basictab3">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="userName">Kegunaan
                                                    Baja</label>
                                                <div class="col-md-9">
                                                    <select name="fertilizer_type[]" id="fertilizer_type"
                                                        class="form-control">
                                                        <option>Sila Pilih</option>
                                                        <option value="Tumbesaran">Tumbesaran</option>
                                                        <option value="Akar Pokok">Akar Pokok</option>
                                                        <option value="Buah">Buah</option>
                                                        <option value="Matang">Matang</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="namabaja"> Nama Baja</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="fertilizer_name[]" class="form-control"
                                                        id="inputNamaBaja" placeholder="Eg: Urea">
                                                </div>
                                            </div>

                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="confirm">Muat Naik
                                                    Gambar</label>
                                                <div class="col-md-9">
                                                    <input type="file" name="image[]" class="form-control"
                                                        id="image" accept="image/*">
                                                </div>
                                            </div>
                                        </div> <!-- end col -->
                                    </div> <!-- end row -->
                                </div>

                                <div class="tab-pane" id="basictab4">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="userName">Kegunaan
                                                    Baja</label>
                                                <div class="col-md-9">
                                                    <select name="fertilizer_type[]" id="fertilizer_type"
                                                        class="form-control">
                                                        <option>Sila Pilih</option>
                                                        <option value="Tumbesaran">Tumbesaran</option>
                                                        <option value="Akar Pokok">Akar Pokok</option>
                                                        <option value="Buah">Buah</option>
                                                        <option value="Matang">Matang</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="namabaja"> Nama Baja</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="fertilizer_name[]" class="form-control"
                                                        id="inputNamaBaja" placeholder="Eg: Urea">
                                                </div>
                                            </div>

                                            <div class="form-group row mb-3">
                                                <label class="col-md-3 col-form-label" for="confirm">Muat Naik
                                                    Gambar</label>
                                                <div class="col-md-9">
                                                    <input type="file" name="image[]" class="form-control"
                                                        id="image" accept="image/*">
                                                </div>
                                            </div>
                                            <li class="next list-inline-item float-right">
                                                <button type="submit" class="btn btn-primary">Simpan</button>
                                            </li> <br><br><br>
                                        </div> <!-- end col -->
                                    </div> <!-- end row -->
                                </div>


                                <ul class="list-inline wizard mb-0">
                                    <li class="previous list-inline-item">
                                        <a href="#" class="btn btn-secondary">Kembali</a>
                                    </li>
                                    {{-- <li class="next list-inline-item float-right">
                                        <button type="submit" class="btn btn-secondary">Simpan</button>
                                    </li> --}}
                                    <li class="next list-inline-item float-right">
                                        <button type="button" class="btn btn-secondary"
                                            id="nextButton">Seterusnya</button> &nbsp;
                                    </li>
                                </ul>
                            </div> <!-- tab-content -->
                        </div> <!-- end #basicwizard-->
                    </form>
                </div> <!-- end card -->
            </div><!-- end col-->
        </div>
        <!-- end row-->
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let currentTab = 0; // Current tab is set to be the first tab (0)
            showTab(currentTab); // Display the current tab

            document.getElementById('nextButton').addEventListener('click', function() {
                if (currentTab < 3) { // Assuming you have 4 tabs (0 to 3)
                    currentTab++;
                    showTab(currentTab);
                }
            });

            function showTab(n) {
                // This function will display the specified tab of the form...
                let tabs = document.querySelectorAll('.tab-pane');
                tabs.forEach((tab, index) => {
                    tab.style.display = (index === n) ? 'block' :
                        'none'; // Show the current tab and hide the others
                });
            }
        });
    </script>

@endsection
